/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import redempt.redlib.commandmanager.ArgType;
import redempt.redlib.commandmanager.Command;
import redempt.redlib.commandmanager.CommandCollection;
import redempt.redlib.commandmanager.Constraint;
import redempt.redlib.commandmanager.ContextProvider;
import redempt.redlib.commandmanager.Messages;
import redempt.redlib.commandmanager.exceptions.CommandParseException;
import redempt.redlib.commandmanager.processing.CommandArgument;
import redempt.redlib.commandmanager.processing.CommandFlag;

public class CommandParser {
    private ArgType<?>[] argTypes = new ArgType[0];
    private ContextProvider<?>[] contextProviders = new ContextProvider[]{ContextProvider.self};
    private InputStream stream;
    private Messages messages;

    public CommandParser(InputStream stream) {
        this(stream, null);
    }

    public CommandParser(InputStream stream, Messages messages) {
        this.stream = stream;
        this.messages = messages;
    }

    public CommandParser setArgTypes(ArgType<?> ... types) {
        if (Arrays.stream(types).anyMatch(t -> t == null)) {
            throw new IllegalArgumentException("Command argument types cannot be null!");
        }
        this.argTypes = types;
        return this;
    }

    public CommandParser setContextProviders(ContextProvider<?> ... providers) {
        if (Arrays.stream(providers).anyMatch(t -> t == null)) {
            throw new IllegalArgumentException("Context providers cannot be null!");
        }
        ArrayList<ContextProvider<Player>> list = new ArrayList<ContextProvider<Player>>();
        list.add(ContextProvider.self);
        Collections.addAll(list, providers);
        this.contextProviders = list.toArray(new ContextProvider[0]);
        return this;
    }

    public CommandCollection parse() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
        String line = "";
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("{") && lines.size() > 0) {
                    String prev = (String)lines.get(lines.size() - 1);
                    lines.set(lines.size() - 1, prev + " {");
                    continue;
                }
                lines.add(line.trim());
            }
        }
        catch (EOFException prev) {
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return this.fromLines(lines, 0);
    }

    private CommandParseException error(String message, int line) {
        return new CommandParseException(message + ", line " + (line + 1));
    }

    private CommandCollection fromLines(List<String> lines, int lineNumber) {
        int depth = 0;
        String help = null;
        String[] names = null;
        ArrayList<CommandArgument> args = new ArrayList<CommandArgument>();
        ArrayList<CommandFlag> flags = new ArrayList<CommandFlag>();
        ArrayList<ContextProvider> contextProviders = new ArrayList<ContextProvider>();
        ArrayList<ContextProvider> asserters = new ArrayList<ContextProvider>();
        String permission = null;
        String hook = null;
        Command.SenderType type = Command.SenderType.EVERYONE;
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList<Command> children = new ArrayList<Command>();
        boolean hideSub = false;
        boolean noTab = false;
        boolean noHelp = false;
        boolean postArg = false;
        for (int pos = lineNumber; pos < lines.size(); ++pos) {
            String line = lines.get(pos);
            if (line.startsWith("//")) continue;
            if (line.endsWith("{")) {
                if (++depth == 1) {
                    CommandArgument arg;
                    int i;
                    String[] split = CommandParser.splitArgs(line = line.substring(0, line.length() - 1).trim());
                    if (split.length == 0) {
                        throw this.error("Command name not specified", pos);
                    }
                    names = split[0].split(",");
                    for (i = 1; i < split.length; ++i) {
                        if (split[i].startsWith("-") && !split[i].contains(":")) {
                            split[i] = "boolean:" + split[i];
                        }
                        if ((arg = this.parseArg(split[i], i, pos)).getName().startsWith("-")) {
                            if (arg.getType().getParent() != null) {
                                throw this.error("Flags cannot use argument subtypes", pos);
                            }
                            if (arg.isOptional()) {
                                throw this.error("Flags cannot be marked as optional, they are optional by definition", pos);
                            }
                            if (arg.consumes() || arg.isVararg()) {
                                throw this.error("Flags cannot be consuming or vararg", pos);
                            }
                            CommandFlag flag = new CommandFlag(arg.getType(), arg.getName(), arg.getConstraint(), arg.getPosition(), arg.getDefaultValue(), arg.isContextDefault());
                            for (String name : flag.getNames()) {
                                if (name.startsWith("-")) continue;
                                throw this.error("All flag names and aliases must start with a dash", pos);
                            }
                            flags.add(flag);
                            continue;
                        }
                        ArgType<?> parent = arg.getType().getParent();
                        if (parent != null && args.size() > 0 && !((CommandArgument)args.get(args.size() - 1)).getType().getName().equals(parent.getName())) {
                            throw this.error("Argument " + arg.getName() + " with subtype " + arg.getType().getName() + " must be preceded by an argument of type " + parent.getName(), pos);
                        }
                        args.add(arg);
                    }
                    i = 0;
                    while (i + 1 < args.size()) {
                        arg = (CommandArgument)args.get(i);
                        if (arg.isVararg() || arg.consumes()) {
                            throw this.error("Vararg and consuming arguments must the final argument in the arg list", pos);
                        }
                        ++i;
                    }
                } else if (depth == 2) {
                    children.addAll(this.fromLines(lines, pos).getCommands());
                }
            } else if (depth == 1) {
                String[] tag = CommandParser.getTag(line);
                try {
                    block15 : switch (tag[0]) {
                        case "help": {
                            if (help == null) {
                                help = tag[1];
                                break;
                            }
                            help = help + "\n" + tag[1];
                            break;
                        }
                        case "helpmsg": {
                            if (this.messages == null) {
                                throw this.error("No Messages supplied, cannot use helpmsg tag", pos);
                            }
                            help = this.messages.get(tag[1]).replace("\\n", "\n");
                            break;
                        }
                        case "permission": {
                            permission = tag[1];
                            break;
                        }
                        case "user": 
                        case "users": {
                            switch (tag[1]) {
                                case "player": 
                                case "players": {
                                    type = Command.SenderType.PLAYER;
                                    break block15;
                                }
                                case "console": 
                                case "server": {
                                    type = Command.SenderType.CONSOLE;
                                    break block15;
                                }
                            }
                            type = Command.SenderType.EVERYONE;
                            break;
                        }
                        case "context": {
                            ContextProvider provider;
                            contextProviders.clear();
                            String[] split = tag[1].split(" ");
                            int fpos = pos;
                            for (String name : split) {
                                provider = Arrays.stream(this.contextProviders).filter(c -> c.getName().equals(name)).findFirst().orElseThrow(() -> this.error("Missing context provider " + name, fpos));
                                contextProviders.add(provider);
                            }
                        }
                        case "assert": {
                            ContextProvider provider;
                            asserters.clear();
                            String[] split = tag[1].split(" ");
                            int fpos = pos;
                            for (String name : split) {
                                provider = Arrays.stream(this.contextProviders).filter(c -> c.getName().equals(name)).findFirst().orElseThrow(() -> this.error("Missing context provider " + name, fpos));
                                asserters.add(provider);
                            }
                        }
                        case "hidesub": {
                            hideSub = true;
                            break;
                        }
                        case "notab": {
                            noTab = true;
                            break;
                        }
                        case "nohelp": {
                            noHelp = true;
                            break;
                        }
                        case "hook": {
                            hook = tag[1];
                            break;
                        }
                        case "postarg": {
                            if (lineNumber == 0) {
                                throw this.error("Only subcommands may be post-argument commands", pos);
                            }
                            postArg = true;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw this.error("Missing tag data for tag " + tag[0], pos);
                }
            }
            if (!line.equals("}") || --depth != 0) continue;
            if (children.stream().anyMatch(Command::isPostArg)) {
                if (args.stream().anyMatch(CommandArgument::isOptional)) {
                    throw this.error("Commands with optional arguments may not have post-argument children", pos);
                }
                if (args.stream().anyMatch(CommandArgument::takesAll)) {
                    throw this.error("Commands with vararg or consuming arguments may not have post-argument children", pos);
                }
            }
            commands.add(new Command(names, args.toArray(new CommandArgument[args.size()]), flags.toArray(new CommandFlag[flags.size()]), contextProviders.toArray(new ContextProvider[contextProviders.size()]), asserters.toArray(new ContextProvider[asserters.size()]), help, permission, type, hook, children, hideSub, noTab, noHelp, postArg));
            children = new ArrayList();
            names = null;
            args = new ArrayList();
            flags = new ArrayList();
            contextProviders = new ArrayList();
            asserters = new ArrayList();
            help = null;
            permission = null;
            type = Command.SenderType.EVERYONE;
            hook = null;
            hideSub = false;
            noTab = false;
            noHelp = false;
            postArg = false;
            if (lineNumber == 0) continue;
            return new CommandCollection(commands);
        }
        if (lineNumber == 0) {
            commands.stream().forEach(c -> {
                c.topLevel = true;
            });
        }
        return new CommandCollection(commands);
    }

    private CommandArgument parseArg(String arg, int argPos, int pos) {
        Constraint<?> realConstraint;
        CommandArgument carg;
        ArgType<?> argType;
        String[] argSplit = arg.split(":");
        if (argSplit.length != 2) {
            throw this.error("Invalid command argument syntax" + arg, pos);
        }
        String constraint = null;
        boolean consumes = false;
        boolean vararg = false;
        if (argSplit[0].endsWith("...")) {
            consumes = true;
            argSplit[0] = argSplit[0].substring(0, argSplit[0].length() - 3);
        }
        if (argSplit[0].endsWith("[]")) {
            vararg = true;
            argSplit[0] = argSplit[0].substring(0, argSplit[0].length() - 2);
            if (consumes) {
                throw this.error("Argument cannot be both consuming and vararg", pos);
            }
        }
        if (argSplit[0].endsWith(">")) {
            int start = argSplit[0].indexOf(60);
            if (start == -1) {
                throw this.error("Invalid syntax for constraint", pos);
            }
            constraint = argSplit[0].substring(start + 1, argSplit[0].length() - 1);
            argSplit[0] = argSplit[0].substring(0, start);
        }
        if ((argType = Command.getType(argSplit[0], this.argTypes)) == null) {
            throw this.error("Missing command argument type " + argSplit[0], pos);
        }
        String name = argSplit[1];
        boolean hideType = false;
        boolean optional = false;
        boolean contextDefault = false;
        Function<CommandSender, Object> defaultValue = c -> null;
        int startIndex = -1;
        startIndex = name.indexOf(40);
        if (startIndex != -1) {
            int pdepth = 0;
            int length = 0;
            for (int j = startIndex; j < name.length(); ++j) {
                char c2 = name.charAt(j);
                ++length;
                if (c2 == '(') {
                    ++pdepth;
                }
                if (c2 == ')' && --pdepth == 0) break;
            }
            if (pdepth != 0) {
                throw this.error("Unbalanced parenthesis in argument: " + name, pos);
            }
            if (startIndex + length < name.length()) {
                throw this.error("Invalid format for argument " + name + ": Cannot define any argument info after default value (parenthesis)", pos);
            }
            String value = name.substring(startIndex + 1, startIndex + length - 1);
            name = name.substring(0, startIndex);
            if (value.startsWith("context ")) {
                String pname = value.substring(8);
                ContextProvider provider = Arrays.stream(this.contextProviders).filter(c -> c.getName().equals(pname)).findFirst().orElseThrow(() -> this.error("Missing context provider " + pname, pos));
                defaultValue = c -> provider.provide((Player)c);
                contextDefault = true;
            } else {
                defaultValue = c -> argType.convert((CommandSender)c, null, value.startsWith("\\") ? value.substring(1) : value);
            }
        }
        if (name.endsWith("*?") || name.endsWith("?*")) {
            hideType = true;
            optional = true;
            name = name.substring(0, name.length() - 2);
        }
        if (name.endsWith("*")) {
            hideType = true;
            name = name.substring(0, name.length() - 1);
        }
        if (name.endsWith("?")) {
            optional = true;
            name = name.substring(0, name.length() - 1);
        }
        if (name.equals(argType.getName())) {
            hideType = true;
        }
        if ((carg = new CommandArgument(argType, argPos - 1, name, realConstraint = constraint == null ? null : argType.getConstraint(constraint).setName(constraint), optional, hideType, consumes, vararg)).isOptional() || name.startsWith("-")) {
            carg.setDefaultValue(defaultValue, contextDefault);
        }
        return carg;
    }

    private static String[] getTag(String line) {
        int index = line.indexOf(32);
        if (index == -1) {
            return new String[]{line};
        }
        return new String[]{line.substring(0, index), line.substring(index + 1)};
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] splitArgs(String args) {
        ArrayList<String> split = new ArrayList<String>();
        StringBuilder combine = new StringBuilder();
        int[] depth = new int[]{0, 0};
        block8: for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 >= args.length()) break;
                    combine.append(args.charAt(i + 1));
                    ++i;
                    break;
                }
                case '(': {
                    depth[0] = depth[0] + 1;
                    break;
                }
                case ')': {
                    depth[0] = depth[0] - 1;
                    break;
                }
                case '<': {
                    depth[1] = depth[1] + 1;
                    break;
                }
                case '>': {
                    depth[1] = depth[1] - 1;
                    break;
                }
                case ' ': {
                    if (depth[0] == 0 && depth[1] == 0) {
                        split.add(combine.toString());
                        combine = new StringBuilder();
                        continue block8;
                    }
                    combine.append(c);
                    continue block8;
                }
            }
            combine.append(c);
        }
        if (combine.length() > 0) {
            split.add(combine.toString());
        }
        return split.toArray(new String[split.size()]);
    }
}

