/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import redempt.redlib.commandmanager.ArgSubtype;
import redempt.redlib.commandmanager.Constraint;
import redempt.redlib.commandmanager.processing.CommandProcessUtils;

public class ArgType<T> {
    private ArgConverter<T, ?> convert;
    private ArgType<?> parent;
    private TabCompleter<?> tab = null;
    private String name;
    private Function<String, Constraint<T>> constraint;

    public static ArgType<?> getDefault(String name) {
        return CommandProcessUtils.getBaseArgTypes().stream().filter(a -> a.getName().equals(name)).findFirst().orElse(null);
    }

    public static <T extends Enum> ArgType<T> of(String name, Class<T> clazz) {
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException("Class must be an enum type!");
        }
        try {
            Method getValues = clazz.getDeclaredMethod("values", new Class[0]);
            Object[] values = (Object[])getValues.invoke(null, new Object[0]);
            List strings = Arrays.stream(values).map(Object::toString).collect(Collectors.toList());
            return new ArgType<Enum>(name, s -> {
                try {
                    return Enum.valueOf(clazz, s);
                }
                catch (Exception e) {
                    return null;
                }
            }).setTab((CommandSender c) -> strings);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArgType<String> of(String name, String ... values) {
        List list = Arrays.stream(values).collect(Collectors.toList());
        return new ArgType<String>(name, s -> list.contains(s) ? s : null).setTab((CommandSender c) -> list);
    }

    public static <T> ArgType<T> of(String name, Map<String, T> map) {
        return new ArgType<Object>(name, map::get).tabStream((CommandSender c) -> map.keySet().stream());
    }

    private static <T, K> T convertCast(ArgConverter<T, K> convert, CommandSender sender, Object previous, String str) {
        return convert.convert(sender, previous, str);
    }

    private static <T> List<String> tabCast(TabCompleter<T> tab, CommandSender sender, String[] args, Object prev) {
        return tab.tabComplete(sender, args, prev);
    }

    protected ArgType(String name, ArgType<?> parent, ArgConverter<T, ?> convert) {
        if (name.contains(" ")) {
            throw new IllegalArgumentException("Command argument type name cannot contain a space");
        }
        this.convert = convert;
        this.name = name;
        this.parent = parent;
    }

    public ArgType<?> getParent() {
        return this.parent;
    }

    public ArgType(String name, Function<String, T> convert) {
        this(name, (CommandSender c, String s) -> convert.apply((String)s));
    }

    public ArgType(String name, BiFunction<CommandSender, String, T> convert) {
        this(name, null, (c, p, s) -> convert.apply(c, s));
    }

    public ArgType<T> setTab(Function<CommandSender, List<String>> tab) {
        this.tab = (c, s, o) -> {
            List list = (List)tab.apply(c);
            return list == null ? new ArrayList() : list;
        };
        return this;
    }

    public ArgType<T> constraint(Function<String, Constraint<T>> constraint) {
        this.constraint = constraint;
        return this;
    }

    public boolean checkConstraint(CommandSender sender, Constraint<T> constraint, T value) {
        return constraint == null || this.constraint == null || value == null || constraint.test(sender, value);
    }

    public ArgType<T> setTab(BiFunction<CommandSender, String[], List<String>> tab) {
        this.tab = (c, s, o) -> {
            List list = (List)tab.apply(c, s);
            return list == null ? new ArrayList() : list;
        };
        return this;
    }

    protected ArgType<T> setTab(TabCompleter<?> tab) {
        this.tab = tab;
        return this;
    }

    public ArgType<T> tabStream(Function<CommandSender, Stream<String>> tab) {
        this.tab = (c, s, o) -> {
            Stream stream = (Stream)tab.apply(c);
            return stream == null ? new ArrayList() : stream.collect(Collectors.toList());
        };
        return this;
    }

    public ArgType<T> tabStream(BiFunction<CommandSender, String[], Stream<String>> tab) {
        this.tab = (c, s, o) -> {
            Stream stream = (Stream)tab.apply(c, s);
            return stream == null ? new ArrayList() : stream.collect(Collectors.toList());
        };
        return this;
    }

    public List<String> tabComplete(CommandSender sender, String[] args, Object prev) {
        if (this.tab == null || prev == null && this.parent != null) {
            return new ArrayList<String>();
        }
        List<String> values = ArgType.tabCast(this.tab, sender, args, prev);
        if (values == null) {
            return new ArrayList<String>();
        }
        return values;
    }

    public String getName() {
        return this.name;
    }

    public T convert(CommandSender sender, Object previous, String argument) {
        return ArgType.convertCast(this.convert, sender, previous, argument);
    }

    public Constraint<T> getConstraint(String constraintContents) {
        return this.constraint == null ? null : this.constraint.apply(constraintContents);
    }

    public <K> ArgType<K> map(String name, Function<T, K> func) {
        return new ArgType<Object>(name, this.parent, (c, p, s) -> {
            T obj = this.convert(c, p, s);
            if (obj == null) {
                return null;
            }
            return func.apply(obj);
        }).setTab(this.tab);
    }

    public <K> ArgType<K> map(String name, BiFunction<CommandSender, T, K> func) {
        return new ArgType<Object>(name, this.parent, (c, p, s) -> {
            T obj = this.convert(c, p, s);
            if (obj == null) {
                return null;
            }
            return func.apply(c, obj);
        }).setTab(this.tab);
    }

    public <K> ArgSubtype<K, T> subType(String name, BiFunction<String, T, K> convert) {
        return new ArgSubtype(name, this, (c, p, s) -> convert.apply(s, p));
    }

    public <K> ArgSubtype<K, T> subType(String name, ArgConverter<K, T> convert) {
        return new ArgSubtype(name, this, convert);
    }

    public static interface ArgConverter<T, K> {
        public T convert(CommandSender var1, K var2, String var3);
    }

    public static interface TabCompleter<T> {
        public List<String> tabComplete(CommandSender var1, String[] var2, T var3);
    }

    public static interface TabStreamCompleter<T> {
        public Stream<String> tabComplete(CommandSender var1, T var2, String[] var3);
    }
}

