/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.protection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import redempt.redlib.RedLib;
import redempt.redlib.misc.EventListener;
import redempt.redlib.protection.ProtectionPolicy;
import redempt.redlib.region.CuboidRegion;

class ProtectionListener {
    ProtectionListener() {
    }

    private static boolean testAll(Block block, ProtectionPolicy.ProtectionType type, Player player) {
        for (ProtectionPolicy policy : ProtectionPolicy.globalPolicies) {
            if (policy.allow(block, type, player)) continue;
            return false;
        }
        Set<ProtectionPolicy> applicable = ProtectionPolicy.regionMap.get(block.getLocation());
        for (ProtectionPolicy policy : applicable) {
            if (policy.allow(block, type, player)) continue;
            return false;
        }
        return true;
    }

    private static boolean testAll(Block outside, List<Block> inside, ProtectionPolicy.ProtectionType type, Player player) {
        if (inside == null) {
            return true;
        }
        Location min = outside.getLocation();
        Location max = outside.getLocation();
        for (Block block : inside) {
            max.setX(Math.max(max.getX(), (double)block.getX()));
            max.setY(Math.max(max.getY(), (double)block.getY()));
            max.setZ(Math.max(max.getZ(), (double)block.getZ()));
            min.setX(Math.min(min.getX(), (double)block.getX()));
            min.setY(Math.min(min.getY(), (double)block.getY()));
            min.setZ(Math.min(min.getZ(), (double)block.getZ()));
        }
        CuboidRegion region = new CuboidRegion(min, max);
        int radius = (int)Arrays.stream(region.getDimensions()).max().getAsDouble();
        Set<ProtectionPolicy> applicable = ProtectionPolicy.regionMap.getNearby(region.getCenter(), radius);
        for (ProtectionPolicy policy : applicable) {
            if (!policy.allow(outside, type, player) || !inside.stream().anyMatch(b -> !policy.allow((Block)b, type, player))) continue;
            return false;
        }
        return true;
    }

    protected static <T extends Event> void protect(Class<T> clazz, ProtectionPolicy.ProtectionType type, Function<T, Player> getPlayer, Function<T, Block> ... getBlocks) {
        new EventListener<Event>(RedLib.getInstance(), clazz, EventPriority.HIGHEST, e -> {
            if (((Cancellable)e).isCancelled()) {
                return;
            }
            Player player = null;
            if (getPlayer != null) {
                player = (Player)getPlayer.apply(e);
            }
            for (Function func : getBlocks) {
                Block block = null;
                try {
                    block = (Block)func.apply(e);
                }
                catch (Exception ex) {
                    continue;
                }
                if (block == null || ProtectionListener.testAll(block, type, player)) continue;
                ((Cancellable)e).setCancelled(true);
            }
        });
    }

    protected static <T extends Event> void protectMultiBlock(Class<T> clazz, ProtectionPolicy.ProtectionType type, Function<T, Player> getPlayer, BiConsumer<T, Block> cancel, Function<T, List<Block>> ... getBlocks) {
        new EventListener<Event>(RedLib.getInstance(), clazz, EventPriority.HIGHEST, e -> {
            Player player = null;
            if (getPlayer != null) {
                player = (Player)getPlayer.apply(e);
            }
            for (Function func : getBlocks) {
                ArrayList blocks = null;
                try {
                    blocks = (ArrayList)func.apply(e);
                }
                catch (NullPointerException ex) {
                    continue;
                }
                if (blocks == null) continue;
                blocks = new ArrayList(blocks);
                for (Block block : blocks) {
                    if (ProtectionListener.testAll(block, type, player)) continue;
                    cancel.accept(e, block);
                }
            }
        });
    }

    protected static <T extends Event> void protectDirectional(Class<T> clazz, ProtectionPolicy.ProtectionType type, Function<T, Player> getPlayer, Function<T, Block> getBaseBlock, Function<T, List<Block>> getProtectedBlocks) {
        new EventListener<Event>(RedLib.getInstance(), clazz, EventPriority.HIGHEST, e -> {
            Player player = null;
            if (getPlayer != null) {
                player = (Player)getPlayer.apply(e);
            }
            if (!ProtectionListener.testAll((Block)getBaseBlock.apply(e), (List)getProtectedBlocks.apply(e), type, player)) {
                ((Cancellable)e).setCancelled(true);
            }
        });
    }

    protected static <T extends Event> void protectNonCancellable(Class<T> clazz, ProtectionPolicy.ProtectionType type, Function<T, Player> getPlayer, Consumer<T> cancel, Function<T, Block> ... getBlocks) {
        new EventListener<Event>(RedLib.getInstance(), clazz, EventPriority.HIGHEST, e -> {
            Player player = null;
            if (getPlayer != null) {
                player = (Player)getPlayer.apply(e);
            }
            for (Function func : getBlocks) {
                Block block = (Block)func.apply(e);
                if (ProtectionListener.testAll(block, type, player)) continue;
                cancel.accept(e);
            }
        });
    }
}

