/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class EntityPersistor<T extends Entity> {
    private T entity;

    public static <T extends Entity> T persist(final T entity) {
        Class<?> clazz = entity.getClass();
        boolean foundInterface = false;
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!Entity.class.isAssignableFrom(iface)) continue;
            clazz = iface;
            foundInterface = true;
            break;
        }
        if (!foundInterface) {
            throw new IllegalArgumentException("The provided object cannot be wrapped!");
        }
        return (T)((Entity)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){
            private T instance;
            {
                this.instance = entity;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Entity replace;
                if (!this.instance.isValid() && (replace = Bukkit.getEntity((UUID)this.instance.getUniqueId())) != null) {
                    this.instance = replace;
                }
                if (method.getName().equals("equals") && method.getParameters().length == 1 && method.getParameters()[0].getName().equals("Object")) {
                    if (args[0] instanceof Entity) {
                        return ((Entity)args[0]).getUniqueId().equals(this.instance.getUniqueId());
                    }
                    return false;
                }
                return method.invoke(this.instance, args);
            }
        }));
    }

    public static <T extends Entity> EntityPersistor<T> wrap(T entity) {
        return new EntityPersistor<T>(entity);
    }

    private EntityPersistor(T entity) {
        this.entity = entity;
    }

    public T get() {
        block4: {
            if (!this.entity.isValid()) {
                for (Entity entity : this.entity.getLocation().getChunk().getEntities()) {
                    if (!entity.getUniqueId().equals(this.entity.getUniqueId())) continue;
                    this.entity = entity;
                    break block4;
                }
                block1: for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        if (!this.entity.getUniqueId().equals(entity.getUniqueId())) continue;
                        this.entity = entity;
                        continue block1;
                    }
                }
            }
        }
        return this.entity;
    }
}

