/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.itemutils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LoreStats {
    private Map<String, LorePlaceholder> placeholders = new HashMap<String, LorePlaceholder>();
    private List<String> lines;
    private boolean fixedLore = true;

    public LoreStats(List<String> lines, String ... placeholders) {
        this.lines = lines;
        for (String name : placeholders) {
            String full = '%' + name + '%';
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                int posStart = line.indexOf(full);
                if (posStart == -1) continue;
                int posFromEnd = line.length() - (posStart + full.length());
                LorePlaceholder placeholder = new LorePlaceholder(name, i, posStart, posFromEnd);
                this.placeholders.put(name, placeholder);
            }
        }
    }

    public void setFixedLore(boolean fixedLore) {
        this.fixedLore = fixedLore;
    }

    private int getLine(ItemStack item, LorePlaceholder placeholder, String name) {
        if (placeholder == null) {
            throw new IllegalArgumentException("Placeholder '" + name + "' has not been registered");
        }
        List lore = item.getItemMeta().getLore();
        int line = placeholder.getLine();
        if (!this.fixedLore) {
            String loreLine = this.lines.get(placeholder.getLine());
            String start = loreLine.substring(0, placeholder.getPosStart());
            String end = loreLine.substring(loreLine.length() - placeholder.getPosFromEnd());
            for (int i = 0; i < lore.size(); ++i) {
                String str = (String)lore.get(i);
                if (!str.startsWith(start) || !str.endsWith(end)) continue;
                line = i;
                break;
            }
            line = -1;
        }
        if (line >= lore.size()) {
            return -1;
        }
        return line;
    }

    public String getStat(ItemStack item, String placeholder) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        LorePlaceholder lp = this.placeholders.get(placeholder);
        List lore = item.getItemMeta().getLore();
        int line = this.getLine(item, lp, placeholder);
        if (line == -1) {
            return null;
        }
        String str = (String)lore.get(line);
        return str.substring(lp.getPosStart(), str.length() - lp.getPosFromEnd());
    }

    public int getInt(ItemStack item, String placeholder) {
        return Integer.parseInt(this.getStat(item, placeholder));
    }

    public int getInt(ItemStack item, String placeholder, int defaultValue) {
        String str = this.getStat(item, placeholder);
        if (str == null) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public double getDouble(ItemStack item, String placeholder) {
        return Double.parseDouble(this.getStat(item, placeholder));
    }

    public double getDouble(ItemStack item, String placeholder, double defaultValue) {
        String str = this.getStat(item, placeholder);
        if (str == null) {
            return defaultValue;
        }
        return Double.parseDouble(str);
    }

    public ItemStack set(ItemStack item, String placeholder, Object obj) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        LorePlaceholder lp = this.placeholders.get(placeholder);
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        int line = this.getLine(item, lp, placeholder);
        if (line == -1) {
            return null;
        }
        String str = (String)lore.get(line);
        str = str.substring(0, lp.getPosStart()) + obj + str.substring(str.length() - lp.getPosFromEnd());
        lore.set(line, str);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private static class LorePlaceholder {
        private String name;
        private int line;
        private int posStart;
        private int posFromEnd;

        public LorePlaceholder(String name, int line, int posStart, int posFromEnd) {
            this.name = name;
            this.line = line;
            this.posStart = posStart;
            this.posFromEnd = posFromEnd;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return '%' + this.name + '%';
        }

        public int getLine() {
            return this.line;
        }

        public int getPosStart() {
            return this.posStart;
        }

        public int getPosFromEnd() {
            return this.posFromEnd;
        }
    }
}

