/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.dev.profiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import redempt.redlib.commandmanager.CommandHook;
import redempt.redlib.dev.profiler.PassiveProfiler;
import redempt.redlib.dev.profiler.Profiler;
import redempt.redlib.dev.profiler.SampleSummary;
import redempt.redlib.dev.profiler.TickMonitorProfiler;
import redempt.redlib.misc.FormatUtils;

public class ProfilerCommands {
    private static Profiler profiler = new PassiveProfiler();
    private static SampleSummary summary;
    private static boolean verbose;
    private static boolean showPercent;
    private static Set<SampleSummary.SampleMethod> showChildren;
    private static SampleSummary.SampleMethod selected;
    private static List<SampleSummary> reports;
    private static int childLimit;

    public static Profiler getProfiler() {
        return profiler;
    }

    private TextComponent[] toMessage(SampleSummary.SampleMethod method) {
        TextComponent expand;
        String text = ChatColor.GREEN + (verbose ? method.getName() : method.getShortName()) + "[" + method.getDepth() + "]: " + ChatColor.YELLOW + (showPercent ? FormatUtils.truncateDouble(method.getPrevalence()) + "%" : method.getCount() + "ms");
        TextComponent main = new TextComponent(text);
        HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ChatColor.GREEN + "Click to select")});
        main.setHoverEvent(hover);
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/redlib:profiler select " + this.getSelector(method));
        main.setClickEvent(click);
        if (!showChildren.contains(method)) {
            expand = new TextComponent(ChatColor.GREEN + "" + ChatColor.BOLD + "+ ");
            hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ChatColor.GREEN + "Click to expand")});
            expand.setHoverEvent(hover);
        } else {
            expand = new TextComponent(ChatColor.RED + "" + ChatColor.BOLD + "- ");
            hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ChatColor.GREEN + "Click to collapse")});
            expand.setHoverEvent(hover);
        }
        click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/redlib:profiler toggleexpand " + this.getSelector(method));
        expand.setClickEvent(click);
        return new TextComponent[]{expand, main};
    }

    private String getSelector(SampleSummary.SampleMethod method) {
        List<SampleSummary.SampleMethod> list = summary.getMethodsByName().get(method.getName());
        return method.getName() + "=" + list.indexOf(method);
    }

    private SampleSummary.SampleMethod getSampleMethod(String selector) {
        int index = selector.indexOf(61);
        if (index == -1) {
            return null;
        }
        String name = selector.substring(0, index);
        List<SampleSummary.SampleMethod> list = summary.getMethodsByName().get(name);
        return list.get(Integer.parseInt(selector.substring(index + 1)));
    }

    @CommandHook(value="start")
    public void start(CommandSender sender) {
        profiler.start();
        sender.sendMessage(ChatColor.YELLOW + "RedLib profiler started.");
    }

    @CommandHook(value="stop")
    public void stop(CommandSender sender) {
        profiler.stop();
        sender.sendMessage(ChatColor.YELLOW + "RedLib profiler stopped.");
    }

    @CommandHook(value="summary")
    public void summary(Player sender) {
        summary = profiler.getSummary();
        selected = summary.getRoot();
        showChildren.clear();
        this.showSelection(sender);
    }

    @CommandHook(value="verbose")
    public void verbose(Player sender) {
        verbose = !verbose;
        this.showSelection(sender);
    }

    @CommandHook(value="timeformat")
    public void timeFormat(Player sender) {
        showPercent = !showPercent;
        this.showSelection(sender);
    }

    @CommandHook(value="root")
    public void root(Player player) {
        showChildren.clear();
        selected = summary.getRoot();
        this.showSelection(player);
    }

    @CommandHook(value="select")
    public void select(Player player, String selector) {
        SampleSummary.SampleMethod method = this.getSampleMethod(selector);
        if (method == null) {
            player.sendMessage(ChatColor.RED + "Invalid selector!");
            return;
        }
        selected = method;
        this.showSelection(player);
    }

    @CommandHook(value="up")
    public void up(Player sender, int count) {
        SampleSummary.SampleMethod method = selected;
        if (method == null) {
            sender.sendMessage(ChatColor.RED + "No profiler selection.");
            return;
        }
        for (int i = 0; i < count; ++i) {
            if (method.getParent() == null) continue;
            method = method.getParent();
        }
        selected = method;
        this.showSelection(sender);
    }

    @CommandHook(value="collapse")
    public void collapse(Player player) {
        showChildren.clear();
        this.showSelection(player);
    }

    @CommandHook(value="toggleexpand")
    public void toggleExpand(Player player, String selector) {
        SampleSummary.SampleMethod method = this.getSampleMethod(selector);
        if (!showChildren.add(method)) {
            showChildren.remove(method);
        }
        this.showSelection(player);
    }

    @CommandHook(value="search")
    public void search(Player player, int depth, double overPercent, int overMillis, String term) {
        if (summary == null) {
            player.sendMessage(ChatColor.RED + "No selection.");
            return;
        }
        showChildren.clear();
        List<SampleSummary.SampleMethod> results = this.search(selected, m -> m.getDepth() >= depth && m.getPrevalence() >= overPercent && m.getCount() >= (long)overMillis && m.getName().contains(term));
        player.sendMessage(ChatColor.YELLOW + "Search results (" + results.size() + ")");
        for (SampleSummary.SampleMethod method : results) {
            player.spigot().sendMessage((BaseComponent)this.toMessage(method)[1]);
        }
    }

    private List<SampleSummary.SampleMethod> search(SampleSummary.SampleMethod root, Predicate<SampleSummary.SampleMethod> filter) {
        ArrayList<SampleSummary.SampleMethod> methods = new ArrayList<SampleSummary.SampleMethod>();
        ArrayDeque<SampleSummary.SampleMethod> queue = new ArrayDeque<SampleSummary.SampleMethod>();
        queue.add(root);
        while (queue.size() > 0) {
            SampleSummary.SampleMethod method = (SampleSummary.SampleMethod)queue.poll();
            if (filter.test(method)) {
                methods.add(method);
                continue;
            }
            queue.addAll(method.getChildren());
        }
        methods.sort(Comparator.comparingDouble(SampleSummary.SampleMethod::getPrevalence).reversed());
        return methods;
    }

    @CommandHook(value="setminimum")
    public void setMinimum(CommandSender sender, int ticks) {
        TickMonitorProfiler.setTickMinimum(ticks);
        sender.sendMessage(ChatColor.YELLOW + "Tick monitor minimum duration set.");
    }

    @CommandHook(value="clear")
    public void clear(CommandSender sender) {
        TickMonitorProfiler.clear();
        sender.sendMessage(ChatColor.YELLOW + "Tick monitor reports cleared.");
    }

    @CommandHook(value="startmonitor")
    public void startMonitor(CommandSender sender, Integer minimum) {
        if (minimum != null) {
            TickMonitorProfiler.setTickMinimum(minimum.intValue());
        }
        TickMonitorProfiler.start();
        sender.sendMessage(ChatColor.YELLOW + "Tick monitor profiler started.");
    }

    @CommandHook(value="reports")
    public void showReports(Player player) {
        reports = new ArrayList<SampleSummary>();
        reports.addAll(TickMonitorProfiler.getReports());
        player.sendMessage(ChatColor.YELLOW + "Tick Monitor Reports (" + reports.size() + ")");
        for (int i = 0; i < reports.size(); ++i) {
            SampleSummary report = reports.get(i);
            TextComponent component = new TextComponent(ChatColor.RED + "" + report.getDuration() + "ms tick " + ChatColor.YELLOW + FormatUtils.formatTimeOffset(System.currentTimeMillis() - report.getEnd()) + " ago");
            HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ChatColor.GREEN + "Click to select")});
            component.setHoverEvent(hover);
            ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/redlib:profiler monitor select " + i);
            component.setClickEvent(click);
            player.spigot().sendMessage((BaseComponent)component);
        }
    }

    @CommandHook(value="selectreport")
    public void selectReport(Player player, int report) {
        summary = reports.get(report);
        selected = summary.getRoot();
        showChildren.clear();
        this.showSelection(player);
    }

    @CommandHook(value="limit")
    public void setLimit(Player player, int limit) {
        childLimit = limit;
        this.showSelection(player);
    }

    private void showSelection(Player player) {
        if (selected == null) {
            player.sendMessage(ChatColor.RED + "No profiler selection.");
            return;
        }
        TextComponent component = new TextComponent(ChatColor.RED + "===========================");
        HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ChatColor.GREEN + "Click to go up")});
        component.setHoverEvent(hover);
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/redlib:profiler up");
        component.setClickEvent(click);
        player.spigot().sendMessage((BaseComponent)component);
        this.showSelection(player, selected, selected.getDepth());
    }

    private String repeat(int times) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    private void showSelection(Player player, SampleSummary.SampleMethod method, int depth) {
        TextComponent[] components = this.toMessage(method);
        components[0].setText(this.repeat(method.getDepth() - depth) + components[0].getText());
        player.spigot().sendMessage((BaseComponent[])components);
        if (showChildren.contains(method)) {
            method.getChildren().stream().sorted(Comparator.comparingDouble(SampleSummary.SampleMethod::getPrevalence).reversed()).limit(childLimit).forEach(m -> this.showSelection(player, (SampleSummary.SampleMethod)m, depth));
        }
    }

    static {
        verbose = false;
        showPercent = true;
        showChildren = new HashSet<SampleSummary.SampleMethod>();
        selected = null;
        reports = null;
        childLimit = 30;
    }
}

