/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config;

import java.lang.reflect.Field;
import java.util.List;
import redempt.redlib.config.annotations.ConfigName;
import redempt.redlib.config.instantiation.FieldSummary;

public class ConfigField {
    private Field field;
    private String name;
    private List<String> comments;

    public ConfigField(Field field) {
        this.field = field;
        ConfigName annotation = field.getAnnotation(ConfigName.class);
        this.name = annotation == null ? field.getName() : annotation.value();
        this.comments = FieldSummary.getComments(field);
    }

    public Field getField() {
        return this.field;
    }

    public void set(Object target, Object value) {
        try {
            this.field.set(target, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void set(Object value) {
        this.set(null, value);
    }

    public Object get(Object target) {
        try {
            return this.field.get(target);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object get() {
        return this.get(null);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public void setComments(List<String> comments) {
        this.comments = comments;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigField)) {
            return false;
        }
        ConfigField cf = (ConfigField)o;
        return cf.field.equals(this.field);
    }
}

