/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import redempt.redlib.commandmanager.Message;
import redempt.redlib.commandmanager.processing.CommandProcessUtils;
import redempt.redlib.misc.FormatUtils;

public class Messages {
    private static Map<Plugin, Messages> all = new HashMap<Plugin, Messages>();
    private static Pattern placeholderPattern = Pattern.compile("%\\w+%");
    private Plugin plugin;
    private Map<String, Message> messages;
    private UnaryOperator<String> formatter = FormatUtils::color;

    public static Pattern getDefaultPlaceholderPattern() {
        return placeholderPattern;
    }

    public static Messages load(InputStream defaults, Path path, Pattern placeholderPattern) {
        try {
            String line;
            LinkedHashMap<String, String> messages = Files.exists(path, new LinkOption[0]) ? Messages.parse(Files.readAllLines(path)) : new LinkedHashMap();
            BufferedReader reader = new BufferedReader(new InputStreamReader(defaults));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            Map<String, String> defaultMap = Messages.parse(lines);
            boolean[] missing = new boolean[]{false};
            defaultMap.forEach((k, v) -> {
                if (!messages.containsKey(k)) {
                    messages.put((String)k, (String)v);
                    missing[0] = true;
                }
            });
            if (missing[0]) {
                Messages.write(messages, path);
            }
            HashMap<String, Message> messageMap = new HashMap<String, Message>();
            for (String key : defaultMap.keySet()) {
                messageMap.put(key, new Message((String)messages.get(key), defaultMap.get(key), placeholderPattern));
            }
            return new Messages(null, messageMap);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Messages load(InputStream defaults, Path path) {
        return Messages.load(defaults, path, placeholderPattern);
    }

    public static Messages load(Plugin plugin, InputStream defaults, String filename, Pattern placeholderPattern) {
        Path path = plugin.getDataFolder().toPath().resolve(filename);
        Messages messages = Messages.load(defaults, path, placeholderPattern);
        messages.plugin = plugin;
        all.put(plugin, messages);
        return messages;
    }

    public static Messages load(Plugin plugin, InputStream defaults, String filename) {
        return Messages.load(plugin, defaults, filename, placeholderPattern);
    }

    public static Messages getLoaded(Plugin plugin) {
        return all.get(plugin);
    }

    public static Messages load(Plugin plugin, InputStream defaults, Pattern placeholderPattern) {
        return Messages.load(plugin, defaults, "messages.txt", placeholderPattern);
    }

    public static Messages load(Plugin plugin, InputStream defaults) {
        return Messages.load(plugin, defaults, "messages.txt", placeholderPattern);
    }

    public static Messages load(Plugin plugin, Pattern placeholderPattern) {
        return Messages.load(plugin, plugin.getResource("messages.txt"), "messages.txt", placeholderPattern);
    }

    public static Messages load(Plugin plugin) {
        return Messages.load(plugin, plugin.getResource("messages.txt"), "messages.txt", placeholderPattern);
    }

    public static String msg(String message) {
        Plugin plugin = CommandProcessUtils.getCallingPlugin();
        Messages msgs = all.get(plugin);
        if (msgs == null) {
            throw new IllegalStateException("Your plugin has not loaded any messages, or this method is being called from the wrong plugin");
        }
        return msgs.get(message);
    }

    public static String msgReplace(String message, String ... placeholderValues) {
        Plugin plugin = CommandProcessUtils.getCallingPlugin();
        Messages msgs = all.get(plugin);
        if (msgs == null) {
            throw new IllegalStateException("Your plugin has not loaded any messages, or this method is being called from the wrong plugin");
        }
        return msgs.getAndReplace(message, placeholderValues);
    }

    private static Map<String, String> parse(List<String> input) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String s : input) {
            if (s == null) break;
            int index = s.indexOf(58);
            map.put(s.substring(0, index), s.substring(index + 1).trim());
        }
        return map;
    }

    private static void write(Map<String, String> map, Path file) {
        List lines = map.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.toList());
        try {
            if (!Files.exists(file.getParent(), new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            Files.write(file, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private Messages(Plugin plugin, Map<String, Message> messages) {
        this.messages = messages;
        this.plugin = plugin;
        this.applyFormat();
    }

    private void applyFormat() {
        this.messages.values().forEach(m -> m.setFormatted((String)this.formatter.apply(m.getValue())));
    }

    public Messages setFormatter(UnaryOperator<String> formatter) {
        this.formatter = formatter;
        this.applyFormat();
        return this;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String get(String msg) {
        Message message = this.messages.get(msg);
        if (message == null) {
            throw new IllegalArgumentException("Message '" + msg + "' does not have an assigned or default value!");
        }
        return message.getFormattedValue();
    }

    public String getAndReplace(String msg, String ... placeholderValues) {
        Message message = this.getMessage(msg);
        List<String> placeholders = message.getPlaceholders();
        if (placeholderValues.length != placeholders.size()) {
            throw new IllegalArgumentException("Expected exactly " + placeholders.size() + " placeholder values, got " + placeholderValues.length);
        }
        String val = message.getFormattedValue();
        for (int i = 0; i < placeholders.size(); ++i) {
            val = val.replace(placeholders.get(i), placeholderValues[i]);
        }
        return val;
    }

    public Message getMessage(String msg) {
        return this.messages.get(msg);
    }
}

