/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redempt.redlib.config.ConfigField;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.ConversionManager;
import redempt.redlib.config.annotations.Comment;
import redempt.redlib.config.annotations.Comments;
import redempt.redlib.config.annotations.ConfigMappable;
import redempt.redlib.config.annotations.ConfigName;
import redempt.redlib.config.annotations.ConfigPath;
import redempt.redlib.config.annotations.ConfigPostInit;
import redempt.redlib.config.conversion.StringConverter;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;
import redempt.redlib.config.instantiation.Instantiator;

public class FieldSummary {
    private List<ConfigField> fields;
    private Map<ConfigField, TypeConverter<?>> converters;
    private Field configPath;
    private StringConverter<?> configPathConverter;
    private Method postInit;

    public static List<String> getComments(Field field) {
        Comments comments = field.getAnnotation(Comments.class);
        if (comments == null) {
            Comment comment = field.getAnnotation(Comment.class);
            return comment == null ? null : Collections.singletonList(comment.value());
        }
        return Arrays.stream(comments.value()).map(Comment::value).collect(Collectors.toList());
    }

    public static List<String> getComments(Parameter param) {
        Comments comments = param.getAnnotation(Comments.class);
        if (comments == null) {
            Comment comment = param.getAnnotation(Comment.class);
            return comment == null ? null : Collections.singletonList(comment.value());
        }
        return Arrays.stream(comments.value()).map(Comment::value).collect(Collectors.toList());
    }

    public static FieldSummary getFieldSummary(ConversionManager manager, Class<?> clazz, boolean staticContext) {
        try {
            Field configPath = null;
            StringConverter<?> configPathConverter = null;
            ArrayList<ConfigField> fields = new ArrayList<ConfigField>();
            HashMap converters = new HashMap();
            Method postInit = null;
            while (clazz != null && (staticContext || clazz.isAnnotationPresent(ConfigMappable.class) || Instantiator.isRecord(clazz))) {
                for (Field field : clazz.getDeclaredFields()) {
                    int mod = field.getModifiers();
                    if (field.isSynthetic() || Modifier.isTransient(mod) || Modifier.isStatic(mod) != staticContext) continue;
                    field.setAccessible(true);
                    if (!staticContext && field.isAnnotationPresent(ConfigPath.class)) {
                        configPath = field;
                        configPathConverter = manager.getStringConverter(ConfigType.get(configPath));
                        continue;
                    }
                    ConfigField cf = new ConfigField(field);
                    fields.add(cf);
                    converters.put(cf, manager.getConverter(ConfigType.get(field)));
                }
                if (!staticContext && Instantiator.isRecord(clazz)) {
                    Constructor<?> constructor = clazz.getDeclaredConstructor((Class[])Arrays.stream(clazz.getDeclaredFields()).map(Field::getType).toArray(Class[]::new));
                    Parameter[] params = constructor.getParameters();
                    int pos = 0;
                    for (int i = 0; i < params.length; ++i) {
                        Parameter param = params[i];
                        if (param.isAnnotationPresent(ConfigPath.class)) continue;
                        ((ConfigField)fields.get(pos)).setComments(FieldSummary.getComments(param));
                        ConfigName name = param.getAnnotation(ConfigName.class);
                        if (name == null) continue;
                        ((ConfigField)fields.get(pos)).setName(name.value());
                        ++pos;
                    }
                }
                clazz = clazz.getSuperclass();
            }
            if (!staticContext) {
                postInit = FieldSummary.getPostInitMethod(clazz);
            }
            return new FieldSummary(fields, converters, configPath, configPathConverter, postInit);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Method getPostInitMethod(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (!method.isAnnotationPresent(ConfigPostInit.class)) continue;
            if (Modifier.isStatic(mod) || Modifier.isAbstract(mod)) {
                throw new IllegalStateException("Post-init method may not be static or abstract: " + method.getName());
            }
            if (method.getParameterCount() != 0) {
                throw new IllegalStateException("Post-init method must have no arguments: " + method.getName());
            }
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private FieldSummary(List<ConfigField> fields, Map<ConfigField, TypeConverter<?>> converters, Field configPath, StringConverter<?> configPathConverter, Method postInit) {
        this.fields = fields;
        this.converters = converters;
        this.configPath = configPath;
        this.configPathConverter = configPathConverter;
        this.postInit = postInit;
    }

    public List<ConfigField> getFields() {
        return this.fields;
    }

    public Map<ConfigField, TypeConverter<?>> getConverters() {
        return this.converters;
    }

    public Field getConfigPath() {
        return this.configPath;
    }

    public StringConverter<?> getConfigPathConverter() {
        return this.configPathConverter;
    }

    public Method getPostInit() {
        return this.postInit;
    }

    public void applyComments(DataHolder holder) {
        this.fields.forEach(f -> {
            if (f.getComments() != null) {
                holder.setComments(f.getName(), f.getComments());
            }
        });
    }
}

