/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.conversion;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import redempt.redlib.config.ConfigField;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.ConversionManager;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;
import redempt.redlib.config.instantiation.FieldSummary;
import redempt.redlib.config.instantiation.Instantiator;

public class ObjectConverter {
    public static <T> TypeConverter<T> create(final ConversionManager manager, final ConfigType<?> type) {
        if (type.getType().isInterface() || Modifier.isAbstract(type.getType().getModifiers())) {
            throw new IllegalStateException("Cannot automatically convert abstract classe or interface " + type.getType());
        }
        final Instantiator instantiator = Instantiator.getInstantiator(type.getType());
        final FieldSummary summary = FieldSummary.getFieldSummary(manager, type.getType(), false);
        return new TypeConverter<T>(){

            @Override
            public T loadFrom(DataHolder section, String path, T currentValue) {
                DataHolder newSection = path == null ? section : section.getSubsection(path);
                ArrayList<Object> objs = new ArrayList<Object>();
                for (ConfigField field : summary.getFields()) {
                    Object value = summary.getConverters().get(field).loadFrom(newSection, field.getName(), null);
                    objs.add(value);
                }
                return instantiator.instantiate(manager, currentValue, type.getType(), objs, path, summary);
            }

            @Override
            public void saveTo(T t, DataHolder section, String path) {
                this.saveTo(t, section, path, true);
            }

            @Override
            public void saveTo(T t, DataHolder section, String path, boolean overwrite) {
                if (path != null && section.isSet(path) && !overwrite) {
                    return;
                }
                DataHolder newSection = path == null ? section : section.createSubsection(path);
                for (ConfigField field : summary.getFields()) {
                    ObjectConverter.saveWith(summary.getConverters().get(field), field.get(t), newSection, field.getName(), overwrite);
                }
                summary.applyComments(newSection);
            }
        };
    }

    private static <T> void saveWith(TypeConverter<T> converter, Object obj, DataHolder section, String path, boolean overwrite) {
        converter.saveTo(obj, section, path, overwrite);
    }
}

