/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata.custom;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.blockdata.DataBlock;
import redempt.redlib.blockdata.custom.CustomBlock;

public abstract class CustomBlockType<T extends CustomBlock>
implements Listener {
    private BlockDataManager manager;
    private String typeName;

    public CustomBlockType(String typeName) {
        this.typeName = typeName;
    }

    public boolean itemMatches(ItemStack item) {
        return item.hasItemMeta() && this.getBaseItemName().equals(item.getItemMeta().getDisplayName());
    }

    public abstract void place(Player var1, ItemStack var2, T var3);

    public abstract ItemStack getItem(T var1);

    public List<ItemStack> getDrops(T block) {
        return new ArrayList<ItemStack>();
    }

    public abstract String getBaseItemName();

    protected final void register(BlockDataManager manager) {
        this.manager = manager;
    }

    public boolean typeMatches(Material material) {
        return true;
    }

    public String getName() {
        return this.typeName;
    }

    public T getCustom(DataBlock db) {
        return null;
    }

    public final T get(Block block) {
        return this.get(this.manager.getDataBlock(block, false));
    }

    public final T get(DataBlock db) {
        if (!(db != null && db.getString("custom-type").equals(this.typeName) && this.typeMatches(db.getBlock().getType()) && db.getManager().equals(this.manager))) {
            return null;
        }
        T custom = this.getCustom(db);
        if (custom != null) {
            return custom;
        }
        return (T)new CustomBlock(this, db);
    }

    public final T initialize(Block block) {
        DataBlock db = this.manager.getDataBlock(block);
        db.set("custom-type", this.typeName);
        return this.get(db);
    }
}

