/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.blockdata.DataBlock;
import redempt.redlib.blockdata.events.DataBlockDestroyEvent;
import redempt.redlib.blockdata.events.DataBlockMoveEvent;
import redempt.redlib.json.JSONMap;

class BlockDataListener
implements Listener {
    private BlockDataManager manager;

    public BlockDataListener(BlockDataManager manager, Plugin plugin) {
        this.manager = manager;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    private void fireDestroy(DataBlock db, Event parent, DataBlockDestroyEvent.DestroyCause cause) {
        if (db == null) {
            return;
        }
        DataBlockDestroyEvent ev = new DataBlockDestroyEvent(db, parent, cause);
        Bukkit.getPluginManager().callEvent((Event)ev);
        if (!ev.isCancelled()) {
            this.manager.remove(db);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        DataBlock db = this.manager.getDataBlock(e.getBlock(), false);
        this.fireDestroy(db, (Event)e, DataBlockDestroyEvent.DestroyCause.PLAYER_BREAK);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplode(BlockExplodeEvent e) {
        this.handleExplosion(e.blockList(), (Cancellable)e);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplode(EntityExplodeEvent e) {
        this.handleExplosion(e.blockList(), (Cancellable)e);
    }

    private void handleExplosion(List<Block> blocks, Cancellable e) {
        ArrayList toRemove = new ArrayList();
        blocks.forEach(b -> {
            DataBlock db = this.manager.getDataBlock((Block)b);
            if (db == null) {
                return;
            }
            DataBlockDestroyEvent ev = new DataBlockDestroyEvent(db, (Event)e, DataBlockDestroyEvent.DestroyCause.EXPLOSION);
            Bukkit.getPluginManager().callEvent((Event)ev);
            if (!ev.isCancelled()) {
                toRemove.add(db);
            }
        });
        if (e.isCancelled()) {
            return;
        }
        toRemove.forEach(this.manager::remove);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCombust(BlockBurnEvent e) {
        DataBlock db = this.manager.getDataBlock(e.getBlock());
        this.fireDestroy(db, (Event)e, DataBlockDestroyEvent.DestroyCause.COMBUST);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent e) {
        this.handlePiston(e.getBlocks(), (BlockPistonEvent)e);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent e) {
        this.handlePiston(e.getBlocks(), (BlockPistonEvent)e);
    }

    private void handlePiston(List<Block> blocks, BlockPistonEvent e) {
        ArrayList toMove = new ArrayList();
        blocks.forEach(b -> {
            DataBlock db = this.manager.getDataBlock((Block)b);
            if (db == null) {
                return;
            }
            Block destination = db.getBlock().getRelative(e.getDirection());
            DataBlockMoveEvent ev = new DataBlockMoveEvent(db, destination, (Event)e);
            Bukkit.getPluginManager().callEvent((Event)ev);
            if (!ev.isCancelled()) {
                toMove.add(db);
            }
        });
        if (e.isCancelled()) {
            return;
        }
        HashMap<Block, JSONMap> moved = new HashMap<Block, JSONMap>();
        toMove.forEach(db -> {
            Block destination = db.getBlock().getRelative(e.getDirection());
            moved.put(destination, db.data);
        });
        toMove.forEach(this.manager::remove);
        moved.forEach((block, data) -> {
            this.manager.getDataBlock((Block)block).data = data;
        });
    }
}

