/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.conversion;

import redempt.redlib.config.ConfigManager;
import redempt.redlib.config.ConfigType;
import redempt.redlib.config.conversion.ObjectConverter;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;

public class SubclassConverter {
    public static <T> TypeConverter<T> create(final ConfigManager manager, final Class<T> clazz, boolean isAbstract) {
        final TypeConverter parent = !isAbstract ? ObjectConverter.create(manager, new ConfigType<T>(clazz)) : null;
        return new TypeConverter<T>(){

            @Override
            public T loadFrom(DataHolder section, String path, T currentValue) {
                String typeName = section.getSubsection(path).getString("=type");
                if (typeName == null) {
                    throw new IllegalStateException("Could not determine subclass for object with path " + path);
                }
                Class<?> type = manager.loadClass(typeName);
                if (!clazz.isAssignableFrom(type)) {
                    throw new IllegalStateException(type + " is not a subclass of " + clazz);
                }
                TypeConverter<?> converter = type.equals(clazz) ? parent : manager.getConverter(new ConfigType(type));
                return converter.loadFrom(section, path, currentValue);
            }

            @Override
            public void saveTo(T t, DataHolder section, String path) {
                Class<?> type = t.getClass();
                if (!clazz.isAssignableFrom(type)) {
                    throw new IllegalStateException(type + " is not a subclass of " + clazz);
                }
                TypeConverter<?> converter = type.equals(clazz) ? parent : manager.getConverter(new ConfigType(type));
                converter.saveTo(t, section, path);
                section.getSubsection(path).set("=type", type.getName());
            }
        };
    }
}

