/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import redempt.redlib.RedLib;
import redempt.redlib.blockdata.DataBlock;
import redempt.redlib.blockdata.events.DataBlockDestroyEvent;
import redempt.redlib.blockdata.events.DataBlockMoveEvent;
import redempt.redlib.json.JSONMap;
import redempt.redlib.json.JSONParser;
import redempt.redlib.misc.LocationUtils;
import redempt.redlib.sql.SQLHelper;

public class BlockDataManager
implements Listener {
    private static List<BlockDataManager> managers = new ArrayList<BlockDataManager>();
    private Map<World, Map<ChunkPosition, Set<DataBlock>>> blocks = new HashMap<World, Map<ChunkPosition, Set<DataBlock>>>();
    protected SQLHelper sql;
    private boolean autoUnload = true;

    public static List<BlockDataManager> getAllManagers() {
        return managers;
    }

    public BlockDataManager(Path saveFile) {
        try {
            Files.createDirectories(saveFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, RedLib.getInstance());
        this.sql = new SQLHelper(SQLHelper.openSQLite(saveFile));
        this.sql.execute("CREATE TABLE IF NOT EXISTS blocks (world TEXT, cx INT, cz INT, x INT, y INT, z INT, data TEXT, PRIMARY KEY (world, x, y, z));", new Object[0]);
        this.sql.execute("CREATE INDEX IF NOT EXISTS chunkPos ON blocks (cx, cz);", new Object[0]);
        this.sql.execute("PRAGMA synchronous = OFF;", new Object[0]);
        managers.add(this);
        this.setAutoSave(true);
    }

    public void setAutoSave(boolean autoSave) {
        this.sql.setCommitInterval(autoSave ? 6000 : -1);
    }

    public void setAutoUnload(boolean autoUnload) {
        this.autoUnload = autoUnload;
    }

    public void save() {
        this.getAllLoaded().forEach(DataBlock::save);
        this.sql.commit();
    }

    public void saveAndClose() {
        this.setAutoSave(false);
        this.save();
        this.sql.close();
        managers.remove(this);
        HandlerList.unregisterAll((Listener)this);
    }

    protected Set<DataBlock> ensureExists(World world, ChunkPosition pos) {
        return this.blocks.computeIfAbsent(world, k -> new HashMap()).computeIfAbsent(pos, k -> new HashSet());
    }

    protected Optional<Set<DataBlock>> tryExists(World world, ChunkPosition pos) {
        Map<ChunkPosition, Set<DataBlock>> map = this.blocks.get(world);
        if (map == null) {
            return Optional.empty();
        }
        Set<DataBlock> set = map.get(pos);
        return Optional.ofNullable(set);
    }

    protected ChunkPosition toChunkPosition(Location loc) {
        int[] pos = LocationUtils.getChunkCoordinates(loc);
        return new ChunkPosition(pos[0], pos[1]);
    }

    protected ChunkPosition toChunkPosition(Block block) {
        return this.toChunkPosition(block.getLocation());
    }

    public DataBlock getExisting(Block block) {
        ChunkPosition pos = this.toChunkPosition(block);
        Set<DataBlock> set = this.load(block.getWorld(), pos.x, pos.z);
        for (DataBlock db : set) {
            if (!db.getBlock().equals((Object)block)) continue;
            return db;
        }
        return null;
    }

    public DataBlock getDataBlock(Block block) {
        DataBlock db = this.getExisting(block);
        if (db != null) {
            return db;
        }
        db = new DataBlock(block, this);
        ChunkPosition pos = this.toChunkPosition(block);
        this.load(block.getWorld(), pos.x, pos.z).add(db);
        return db;
    }

    protected void register(DataBlock db) {
        ChunkPosition pos = this.toChunkPosition(db.getBlock());
        this.load(db.getWorld(), pos.x, pos.z).add(db);
    }

    public void remove(DataBlock db) {
        this.sql.execute("DELETE FROM blocks WHERE x=? AND y=? AND z=? AND world=?;", db.getBlock().getX(), db.getBlock().getY(), db.getBlock().getZ(), db.getWorld().getName());
        int[] pos = db.getChunkCoordinates();
        if (this.isChunkLoaded(db.getWorld(), pos[0], pos[1])) {
            this.getLoaded(db.getWorld(), pos[0], pos[1]).remove(db);
        }
    }

    public Set<DataBlock> getNearby(Location loc, int radius) {
        radius /= 16;
        HashSet<DataBlock> set = new HashSet<DataBlock>();
        int[] pos = LocationUtils.getChunkCoordinates(loc);
        for (int x = pos[0] - ++radius; x <= pos[0] + radius; ++x) {
            for (int z = pos[1] - radius; z <= pos[1] + radius; ++z) {
                set.addAll(this.load(loc.getWorld(), x, z));
            }
        }
        return set;
    }

    public Set<DataBlock> getLoaded(Chunk chunk) {
        return this.getLoaded(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public Set<DataBlock> getLoaded(World world, int cx, int cz) {
        return this.tryExists(world, new ChunkPosition(cx, cz)).orElse(new HashSet());
    }

    public Set<DataBlock> load(World world, int cx, int cz) {
        if (this.isChunkLoaded(world, cx, cz)) {
            return this.getLoaded(world, cx, cz);
        }
        Set<DataBlock> set = this.ensureExists(world, new ChunkPosition(cx, cz));
        this.sql.queryResults("SELECT x,y,z,data FROM blocks WHERE world=? AND cx=? AND cz=?;", world.getName(), cx, cz).forEach(r -> {
            int x = (Integer)r.get(1);
            int y = (Integer)r.get(2);
            int z = (Integer)r.get(3);
            JSONMap data = JSONParser.parseMap(r.getString(4));
            Block block = world.getBlockAt(x, y, z);
            DataBlock db = new DataBlock(block, this);
            db.exists = true;
            db.data = data;
            set.add(db);
        });
        return set;
    }

    public Set<DataBlock> load(Chunk chunk) {
        return this.load(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public void unload(World world, int cx, int cz) {
        ChunkPosition pos = new ChunkPosition(cx, cz);
        this.tryExists(world, pos).ifPresent(s -> {
            s.forEach(DataBlock::save);
            this.blocks.get(world).remove(pos);
        });
    }

    public void unload(Chunk chunk) {
        this.unload(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public void unloadAll() {
        this.save();
        this.blocks = new HashMap<World, Map<ChunkPosition, Set<DataBlock>>>();
    }

    public boolean isChunkLoaded(Chunk chunk) {
        return this.isChunkLoaded(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public boolean isChunkLoaded(World world, int cx, int cz) {
        return this.tryExists(world, new ChunkPosition(cx, cz)).isPresent();
    }

    public Set<DataBlock> getAllLoaded() {
        HashSet<DataBlock> set = new HashSet<DataBlock>();
        this.blocks.values().forEach(v -> v.values().forEach(set::addAll));
        return set;
    }

    public Set<DataBlock> getAll() {
        HashSet<DataBlock> set = new HashSet<DataBlock>();
        HashMap positions = new HashMap();
        this.blocks.forEach((w, m) -> positions.computeIfAbsent(w, k -> new HashSet()).addAll(m.keySet()));
        this.sql.queryResults("SELECT world,cx,cz,x,y,z,data FROM blocks;", new Object[0]).forEach(r -> {
            World world = Bukkit.getWorld((String)r.getString(1));
            if (world == null) {
                return;
            }
            int cx = (Integer)r.get(2);
            int cz = (Integer)r.get(3);
            ChunkPosition pos = new ChunkPosition(cx, cz);
            Set pset = (Set)positions.get(world);
            if (pset != null && pset.contains(pos)) {
                this.tryExists(world, pos).ifPresent(set::addAll);
                return;
            }
            int x = (Integer)r.get(4);
            int y = (Integer)r.get(5);
            int z = (Integer)r.get(6);
            JSONMap data = JSONParser.parseMap((String)r.get(7));
            Block block = world.getBlockAt(x, y, z);
            DataBlock db = new DataBlock(block, this);
            db.exists = true;
            db.data = data;
            this.ensureExists(world, pos).add(db);
            set.add(db);
        });
        return set;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreakBlock(BlockBreakEvent e) {
        DataBlock db = this.getExisting(e.getBlock());
        if (db == null) {
            return;
        }
        DataBlockDestroyEvent event = new DataBlockDestroyEvent(db, e.getPlayer(), DataBlockDestroyEvent.DestroyCause.PLAYER, (Event)e);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.setCancelled(true);
            return;
        }
        this.remove(db);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBucketEmpty(PlayerBucketEmptyEvent e) {
        if (RedLib.MID_VERSION >= 13 && e.getBlock().getBlockData() instanceof Waterlogged) {
            return;
        }
        DataBlock db = this.getExisting(e.getBlock());
        if (db == null) {
            return;
        }
        DataBlockDestroyEvent event = new DataBlockDestroyEvent(db, e.getPlayer(), DataBlockDestroyEvent.DestroyCause.PLACE_BUCKET, (Event)e);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.setCancelled(true);
            return;
        }
        this.remove(db);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFlowBreakBlock(BlockFromToEvent e) {
        if (e.getBlock().getType() == Material.DRAGON_EGG) {
            return;
        }
        DataBlock db = this.getExisting(e.getToBlock());
        if (db == null) {
            return;
        }
        DataBlockDestroyEvent event = new DataBlockDestroyEvent(db, null, DataBlockDestroyEvent.DestroyCause.LIQUID, (Event)e);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.setCancelled(true);
            return;
        }
        this.remove(db);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBurnBlock(BlockBurnEvent e) {
        DataBlock db = this.getExisting(e.getBlock());
        if (db == null) {
            return;
        }
        DataBlockDestroyEvent event = new DataBlockDestroyEvent(db, null, DataBlockDestroyEvent.DestroyCause.FIRE, (Event)e);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.setCancelled(true);
            return;
        }
        this.remove(db);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent e) {
        ArrayList toRemove = new ArrayList();
        e.blockList().forEach(block -> {
            DataBlock db = this.getExisting((Block)block);
            if (db == null) {
                return;
            }
            DataBlockDestroyEvent event = new DataBlockDestroyEvent(db, null, DataBlockDestroyEvent.DestroyCause.EXPLOSION, (Event)e);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                toRemove.add(block);
                return;
            }
            this.remove(db);
        });
        e.blockList().removeAll(toRemove);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent e) {
        ArrayList toRemove = new ArrayList();
        e.blockList().forEach(block -> {
            DataBlock db = this.getExisting((Block)block);
            if (db == null) {
                return;
            }
            DataBlockDestroyEvent event = new DataBlockDestroyEvent(db, null, DataBlockDestroyEvent.DestroyCause.EXPLOSION, (Event)e);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                toRemove.add(block);
                return;
            }
            this.remove(db);
        });
        e.blockList().removeAll(toRemove);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPush(BlockPistonExtendEvent e) {
        ArrayList<DataBlock> dataBlocks = new ArrayList<DataBlock>();
        for (Block block : e.getBlocks()) {
            DataBlock db = this.getExisting(block);
            if (db == null) continue;
            dataBlocks.add(db);
        }
        for (DataBlock db : dataBlocks) {
            Block block = db.getBlock().getRelative(e.getDirection());
            DataBlockMoveEvent event = new DataBlockMoveEvent(db, block.getLocation());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            JSONMap map = db.getData();
            db.remove();
            this.getDataBlock(block).setData(map);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPull(BlockPistonRetractEvent e) {
        ArrayList<DataBlock> dataBlocks = new ArrayList<DataBlock>();
        for (Block block : e.getBlocks()) {
            DataBlock db = this.getExisting(block);
            if (db == null) continue;
            dataBlocks.add(db);
        }
        for (DataBlock db : dataBlocks) {
            Block block = db.getBlock().getRelative(e.getDirection());
            DataBlockMoveEvent event = new DataBlockMoveEvent(db, block.getLocation());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            JSONMap map = db.getData();
            db.remove();
            this.getDataBlock(block).setData(map);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkUnload(ChunkUnloadEvent e) {
        if (this.autoUnload) {
            this.unload(e.getChunk());
        }
    }

    private static class ChunkPosition {
        public int x;
        public int z;

        public ChunkPosition(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChunkPosition)) {
                return false;
            }
            ChunkPosition pos = (ChunkPosition)o;
            return pos.x == this.x && pos.z == this.z;
        }
    }
}

