/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import redempt.redlib.RedLib;
import redempt.redlib.itemutils.ItemUtils;
import redempt.redlib.misc.Path;
import redempt.redlib.region.CuboidRegion;

public class SelectionTool
implements Listener {
    private ItemStack item;
    private Map<UUID, Location[]> selections = new HashMap<UUID, Location[]>();
    private Plugin plugin;

    public SelectionTool(ItemStack item) {
        this.item = item;
        Bukkit.getPluginManager().registerEvents((Listener)this, RedLib.getInstance());
        try {
            this.plugin = JavaPlugin.getProvidingPlugin(Class.forName(new Exception().getStackTrace()[1].getClassName()));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent e) {
        if (e.getPlugin().equals((Object)this.plugin)) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getItem() == null) {
            return;
        }
        if (!ItemUtils.compare(e.getItem(), this.item)) {
            return;
        }
        Location[] locations = this.selections.getOrDefault(e.getPlayer().getUniqueId(), new Location[2]);
        if (locations[0] != null && locations[1] != null) {
            locations[0] = null;
            locations[1] = null;
        }
        if (locations[0] == null) {
            locations[0] = e.getClickedBlock().getLocation();
            e.getPlayer().sendMessage(RedLib.msg("firstLocationSet"));
        } else if (locations[1] == null) {
            locations[1] = e.getClickedBlock().getLocation();
            e.getPlayer().sendMessage(RedLib.msg("secondLocationSet"));
        }
        this.selections.put(e.getPlayer().getUniqueId(), locations);
    }

    public ItemStack getItem() {
        return this.item.clone();
    }

    public Location[] getLocations(UUID uuid) {
        return this.selections.getOrDefault(uuid, new Location[2]);
    }

    public CuboidRegion getRegion(UUID uuid) {
        Location[] locations = this.selections.get(uuid);
        if (locations == null || locations[0] == null || locations[1] == null) {
            return null;
        }
        CuboidRegion region = new CuboidRegion(locations[0], locations[1]);
        region.expand(1.0, 0.0, 1.0, 0.0, 1.0, 0.0);
        return region;
    }

    public List<Location> getPath(UUID uuid) {
        Location[] locations = this.selections.get(uuid);
        if (locations[0] == null || locations[1] == null) {
            return null;
        }
        return Path.getPath(locations[0], locations[1]);
    }
}

