/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;
import redempt.redlib.misc.LocationUtils;
import redempt.redlib.multiblock.Rotator;
import redempt.redlib.region.CuboidRegion;
import redempt.redlib.region.MultiRegionMeta;
import redempt.redlib.region.Overlappable;
import redempt.redlib.region.Region;

public class MultiRegion
extends Overlappable {
    private static Vector[] adjacent = new Vector[]{new Vector(0.1, 0.1, 0.1), new Vector(0.1, 0.1, -0.1), new Vector(0.1, -0.1, 0.1), new Vector(-0.1, 0.1, 0.1), new Vector(-0.1, -0.1, 0.1), new Vector(-0.1, 0.1, -0.1), new Vector(0.1, -0.1, -0.1), new Vector(-0.1, -0.1, -0.1)};
    private List<Region> regions = new ArrayList<Region>();
    private List<Region> subtract = new ArrayList<Region>();
    private boolean clustered = false;
    private Location start;
    private Location end;

    public MultiRegion(List<Region> regions) {
        if (regions.size() == 0) {
            throw new IllegalArgumentException("Cannot create MultiRegion from 0 regions");
        }
        World world = regions.get(0).getWorld();
        for (Region region : regions) {
            if (region instanceof MultiRegion) {
                this.clustered = true;
            }
            if (!region.getWorld().equals((Object)world)) {
                throw new IllegalArgumentException("All regions must be in the same world");
            }
            this.regions.add(region);
        }
        this.fixCorners(null);
    }

    private void fixCorners(Region r) {
        if (r == null) {
            World world = this.regions.get(0).getWorld();
            double minX = ((Region)this.regions.stream().min((a, b) -> (int)Math.signum(a.getStart().getX() - b.getStart().getX())).get()).getStart().getX();
            double minY = ((Region)this.regions.stream().min((a, b) -> (int)Math.signum(a.getStart().getY() - b.getStart().getY())).get()).getStart().getY();
            double minZ = ((Region)this.regions.stream().min((a, b) -> (int)Math.signum(a.getStart().getZ() - b.getStart().getZ())).get()).getStart().getZ();
            double maxX = ((Region)this.regions.stream().max((a, b) -> (int)Math.signum(a.getEnd().getX() - b.getEnd().getX())).get()).getEnd().getX();
            double maxY = ((Region)this.regions.stream().max((a, b) -> (int)Math.signum(a.getEnd().getY() - b.getEnd().getY())).get()).getEnd().getY();
            double maxZ = ((Region)this.regions.stream().max((a, b) -> (int)Math.signum(a.getEnd().getZ() - b.getEnd().getZ())).get()).getEnd().getZ();
            this.start = new Location(world, minX, minY, minZ);
            this.end = new Location(world, maxX, maxY, maxZ);
            return;
        }
        World world = this.regions.get(0).getWorld();
        double minX = Math.min(this.start.getX(), r.getStart().getX());
        double minY = Math.min(this.start.getY(), r.getStart().getY());
        double minZ = Math.min(this.start.getZ(), r.getStart().getZ());
        double maxX = Math.max(this.end.getX(), r.getEnd().getX());
        double maxY = Math.max(this.end.getY(), r.getEnd().getY());
        double maxZ = Math.max(this.end.getZ(), r.getEnd().getZ());
        this.start = new Location(world, minX, minY, minZ);
        this.end = new Location(world, maxX, maxY, maxZ);
    }

    protected void setLocations(Location start, Location end) {
        if (!start.getWorld().equals((Object)end.getWorld())) {
            throw new IllegalArgumentException("Locations must be in the same world");
        }
        double minX = Math.min(start.getX(), end.getX());
        double minY = Math.min(start.getY(), end.getY());
        double minZ = Math.min(start.getZ(), end.getZ());
        double maxX = Math.max(start.getX(), end.getX());
        double maxY = Math.max(start.getY(), end.getY());
        double maxZ = Math.max(start.getZ(), end.getZ());
        this.start = new Location(start.getWorld(), minX, minY, minZ);
        this.end = new Location(end.getWorld(), maxX, maxY, maxZ);
    }

    public MultiRegion(Region ... regions) {
        this(Arrays.stream(regions).collect(Collectors.toList()));
    }

    @Override
    public Location getStart() {
        return this.start;
    }

    @Override
    public Location getEnd() {
        return this.end;
    }

    public void add(Region region) {
        if (!(region instanceof Overlappable)) {
            throw new IllegalArgumentException("Cannot add non-Overlappable Region to MultiRegion");
        }
        if (!region.getWorld().equals((Object)this.getWorld())) {
            throw new IllegalArgumentException("Region is not in the same world as this MultiRegion");
        }
        if (region instanceof MultiRegion && !this.clustered) {
            MultiRegion multi = (MultiRegion)region;
            for (Region r : multi.getRegions()) {
                this.regions.add(r.clone());
            }
            this.fixCorners(region);
            return;
        }
        this.regions.add(region.clone());
        this.fixCorners(region);
    }

    public void subtract(Region region) {
        if (!region.getWorld().equals((Object)this.getWorld())) {
            throw new IllegalArgumentException("Region is not in the same world as this MultiRegion");
        }
        this.subtract.add(region.clone());
    }

    @Override
    public boolean contains(Location location) {
        if (!this.getWorld().equals((Object)location.getWorld())) {
            return false;
        }
        if (location.getX() < this.start.getX() || location.getY() < this.start.getY() || location.getZ() < this.start.getZ() || location.getX() > this.end.getX() || location.getY() > this.end.getY() || location.getZ() > this.end.getZ()) {
            return false;
        }
        return MultiRegion.contains(this.regions, location) && !MultiRegion.contains(this.subtract, location);
    }

    private static boolean contains(List<Region> regions, Location loc) {
        return regions.stream().anyMatch(r -> r.contains(loc));
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    @Override
    public int getBlockVolume() {
        int total = 0;
        for (Region region : this.regions) {
            total += region.getBlockVolume();
        }
        for (Region region : this.subtract) {
            total -= region.getBlockVolume();
        }
        return total;
    }

    @Override
    public double getVolume() {
        double total = 0.0;
        for (Region region : this.regions) {
            total += region.getVolume();
        }
        for (Region region : this.subtract) {
            total -= region.getVolume();
        }
        return total;
    }

    @Override
    public MultiRegion clone() {
        ArrayList<Region> clone = new ArrayList<Region>();
        this.regions.stream().map(Region::clone).forEach(clone::add);
        MultiRegion multi = new MultiRegion(clone);
        this.subtract.forEach(multi::subtract);
        return multi;
    }

    @Override
    public MultiRegion expand(BlockFace direction, double amount) {
        if (amount == 0.0) {
            return this;
        }
        if (amount < 0.0) {
            CuboidRegion r = new CuboidRegion(this.start, this.end);
            ((Region)r).expand(direction.getOppositeFace(), -r.measureBlocks(direction));
            ((Region)r).expand(direction.getOppositeFace(), Math.abs(amount));
            this.subtract.add(r);
            return this;
        }
        CuboidRegion r = new CuboidRegion(this.start, this.end);
        ((Region)r).expand(direction.getOppositeFace(), -(r.measureBlocks(direction) - 1));
        MultiRegion slice = this.getIntersection(r);
        slice.move(LocationUtils.getDirection(direction));
        int i = 0;
        while ((double)i < amount) {
            MultiRegion clone = slice.clone();
            clone.move(LocationUtils.getDirection(direction).multiply(i));
            this.add(clone);
            ++i;
        }
        this.fixCorners(null);
        return this;
    }

    @Override
    public MultiRegion expand(double posX, double negX, double posY, double negY, double posZ, double negZ) {
        this.expand(BlockFace.EAST, posX);
        this.expand(BlockFace.WEST, negX);
        this.expand(BlockFace.SOUTH, posZ);
        this.expand(BlockFace.NORTH, negZ);
        this.expand(BlockFace.UP, posY);
        this.expand(BlockFace.DOWN, negY);
        return this;
    }

    public void autoCluster() {
        while (this.regions.size() > 25) {
            this.cluster(10);
        }
    }

    public void cluster(int per) {
        this.clustered = true;
        Region smallest = null;
        for (Region region : this.regions) {
            if (smallest != null && region.getBlockVolume() >= smallest.getBlockVolume()) continue;
            smallest = region;
        }
        Location center = smallest.getCenter();
        this.regions.sort((a, b) -> (int)Math.signum(a.getCenter().distanceSquared(center) - b.getCenter().distanceSquared(center)));
        ArrayList<Region> list = new ArrayList<Region>();
        HashSet<Region> set = new HashSet<Region>();
        set.add(smallest);
        list.add(smallest);
        while (set.size() < this.regions.size()) {
            Region prev = (Region)list.get(list.size() - 1);
            double radius = this.getApproxRadius(prev);
            Location middle = prev.getCenter();
            Region closest = null;
            double distance = 0.0;
            for (Region region : this.regions) {
                if (set.contains(region)) continue;
                double dist = middle.distance(region.getCenter());
                if (dist / 1.5 <= this.getApproxRadius(region) + radius) {
                    closest = region;
                    break;
                }
                if (closest != null && !(dist < distance)) continue;
                distance = dist;
                closest = region;
            }
            set.add(closest);
            list.add(closest);
        }
        ArrayList<Region> cluster = new ArrayList<Region>();
        int count = 0;
        MultiRegion current = null;
        for (int i = 0; i < list.size(); ++i) {
            Region reg = (Region)list.get(i);
            if (current == null) {
                current = new MultiRegion(reg);
            } else {
                current.add(reg);
            }
            if (++count < per) continue;
            cluster.add(current);
            current = null;
            count = 0;
        }
        if (current != null) {
            cluster.add(current);
        }
        this.regions = cluster;
    }

    private double getApproxRadius(Region region) {
        double[] dim = region.getDimensions();
        return (dim[0] + dim[1] + dim[2]) / 3.0;
    }

    public void decluster() {
        if (!this.clustered) {
            return;
        }
        this.clustered = false;
        ArrayList<Region> regions = new ArrayList<Region>();
        for (Region region : this.regions) {
            if (region instanceof MultiRegion) {
                MultiRegion multi = (MultiRegion)region.clone();
                multi.decluster();
                regions.addAll(multi.getRegions());
                continue;
            }
            regions.add(region);
        }
        this.regions = regions;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public int getRegionCount() {
        if (!this.clustered) {
            return this.regions.size();
        }
        int count = 0;
        for (Region region : this.regions) {
            if (region instanceof MultiRegion) {
                count += ((MultiRegion)region).getRegionCount();
                continue;
            }
            ++count;
        }
        return count;
    }

    @Override
    public boolean overlaps(Overlappable overlap) {
        Overlappable o = overlap;
        if (!o.getWorld().equals((Object)this.getWorld())) {
            return false;
        }
        if (o instanceof MultiRegion) {
            MultiRegion multi = (MultiRegion)o;
            return multi.getRegions().stream().anyMatch(r -> ((Overlappable)r).overlaps(this));
        }
        return this.regions.stream().anyMatch(r -> overlap.overlaps((Overlappable)r));
    }

    @Override
    public MultiRegion getIntersection(Overlappable other) {
        MultiRegion region = null;
        for (Region r : this.regions) {
            Region intersect = other.getIntersection((Overlappable)r);
            if (intersect == null) continue;
            if (region == null) {
                region = new MultiRegion(intersect);
                continue;
            }
            region.add(intersect);
        }
        return region;
    }

    @Override
    public MultiRegion move(Vector v) {
        this.regions.forEach(r -> r.move(v));
        this.start = this.start.add(v);
        this.end = this.end.add(v);
        return this;
    }

    @Override
    public Region move(double x, double y, double z) {
        return this.move(new Vector(x, y, z));
    }

    @Override
    public MultiRegion rotate(Location center, int rotations) {
        for (Region region : this.regions) {
            region.rotate(center, rotations);
        }
        Location start = this.getStart();
        Location end = this.getEnd();
        start.subtract(center);
        end.subtract(center);
        Rotator rotator = new Rotator(rotations, false);
        rotator.setLocation(start.getX(), start.getZ());
        start.setX(rotator.getRotatedX());
        start.setZ(rotator.getRotatedZ());
        rotator.setLocation(end.getX(), end.getZ());
        end.setX(rotator.getRotatedX());
        end.setZ(rotator.getRotatedZ());
        start.add(center);
        end.add(center);
        this.setLocations(start, end);
        return this;
    }

    @Override
    public MultiRegion setWorld(World world) {
        this.regions.forEach(r -> r.setWorld(world));
        this.start.setWorld(world);
        this.end.setWorld(world);
        return this;
    }

    public void recalculate() {
        this.recalculate(true);
    }

    public void recalculate(boolean autoCluster) {
        this.decluster();
        MultiRegionMeta summary = new MultiRegionMeta(this.regions);
        List<Region> regions = this.regions;
        ArrayList<Region> newRegions = new ArrayList<Region>();
        MultiRegion[] blocks = new MultiRegion[]{null};
        this.subtract.forEach(r -> {
            if (blocks[0] == null) {
                blocks[0] = new MultiRegion((Region)r);
                return;
            }
            blocks[0].add((Region)r);
        });
        newRegions.addAll(this.subtract);
        Location center = this.start.clone().add(this.end).multiply(0.5).getBlock().getLocation();
        CuboidRegion r2 = new CuboidRegion(center, center);
        if (this.contains(center) && this.expandToMax(r2, null, summary)) {
            newRegions.add(r2);
            blocks[0] = new MultiRegion(r2);
        }
        boolean[] added = new boolean[]{true};
        ArrayList<Region> toRemove = new ArrayList<Region>();
        while (added[0]) {
            added[0] = false;
            for (Region region : regions) {
                Location loc = this.findFreePoint((CuboidRegion)region, newRegions);
                if (loc != null) {
                    CuboidRegion reg = new CuboidRegion(loc, loc);
                    if (!this.expandToMax(reg, blocks[0], summary)) continue;
                    if (blocks[0] == null) {
                        blocks[0] = new MultiRegion(reg);
                    } else {
                        blocks[0].add(reg);
                    }
                    newRegions.add(reg);
                    added[0] = true;
                    continue;
                }
                toRemove.add(region);
            }
            regions.removeAll(toRemove);
            toRemove.clear();
        }
        newRegions.removeAll(this.subtract);
        this.regions = newRegions;
        this.subtract.clear();
        if (!autoCluster) {
            return;
        }
        this.autoCluster();
    }

    private Location findFreePoint(CuboidRegion check, List<Region> exclude) {
        List<Region> intersects = exclude.stream().map(r -> check.getIntersection((Overlappable)r)).filter(Objects::nonNull).collect(Collectors.toList());
        if (intersects.size() == 0) {
            return check.getCenter().getBlock().getLocation();
        }
        for (Region region : intersects) {
            for (Location corner : region.getCorners()) {
                for (Vector vec : adjacent) {
                    Location loc = corner.clone().add(vec).getBlock().getLocation();
                    if (!check.contains(loc) || MultiRegion.contains(intersects, loc)) continue;
                    return loc;
                }
            }
        }
        return null;
    }

    private boolean expandToMax(Region r, MultiRegion exclude, MultiRegionMeta summary) {
        ArrayList faces = new ArrayList(6);
        Collections.addAll(faces, LocationUtils.PRIMARY_BLOCK_FACES);
        boolean expanded = false;
        while (faces.size() > 0) {
            for (int i = 0; i < faces.size(); ++i) {
                double next;
                BlockFace face = (BlockFace)faces.get(i);
                double step = summary.getCurrentStep(r, face);
                if (step == (next = summary.getNextStep(face, step))) {
                    faces.remove(i);
                    continue;
                }
                r.expand(face, Math.abs(next - step));
                if (this.compare(r.getVolume(), this.getNonIntersectingVolume(r)) && (exclude == null || exclude.getNonIntersectingVolume(r) == 0.0)) {
                    expanded = true;
                    continue;
                }
                r.expand(face, -Math.abs(next - step));
                faces.remove(i);
            }
        }
        return r.getVolume() > 0.0 && expanded;
    }

    private boolean compare(double first, double second) {
        return Math.abs(first - second) < 1.0E-5;
    }

    private double getNonIntersectingVolume(Region r) {
        MultiRegion intersection = this.getIntersection((Overlappable)r);
        if (intersection == null) {
            return 0.0;
        }
        double volume = intersection.getVolume();
        List<Region> intersections = intersection.getRegions();
        int overlap = 0;
        while (intersections.size() > 0) {
            Region region = intersections.get(intersections.size() - 1);
            for (int i = 0; i < intersections.size() - 1; ++i) {
                Region other = intersections.get(i);
                Region tmp = ((Overlappable)region).getIntersection((Overlappable)other);
                if (tmp == null || (tmp = ((Overlappable)tmp).getIntersection((Overlappable)r)) == null) continue;
                overlap = (int)((double)overlap + tmp.getVolume());
            }
            intersections.remove(intersections.size() - 1);
        }
        return volume - (double)overlap;
    }

    @Override
    public Stream<Block> stream() {
        Stream<Block> stream = Stream.empty();
        for (Region region : this.regions) {
            stream = Stream.concat(stream, region.stream());
        }
        return stream.filter(b -> this.subtract.stream().noneMatch(r -> r.contains(b.getLocation())));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getWorld().getName()).append(" ");
        for (Region region : this.regions) {
            String str = region.toString();
            str = str.substring(str.indexOf(32) + 1);
            builder.append(str).append(",");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static MultiRegion fromString(String input) {
        int pos = input.indexOf(32);
        World world = Bukkit.getWorld((String)input.substring(0, pos));
        input = input.substring(pos + 1);
        String[] split = input.split(",");
        ArrayList<Region> regions = new ArrayList<Region>(split.length);
        for (String string : split) {
            regions.add(CuboidRegion.fromString(world.getName() + " " + string));
        }
        return new MultiRegion(regions);
    }
}

