/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.protection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import redempt.redlib.RedLib;
import redempt.redlib.misc.EventListener;
import redempt.redlib.protection.BypassPolicy;
import redempt.redlib.protection.ProtectionListener;
import redempt.redlib.protection.ProtectionRegistrations;
import redempt.redlib.region.CuboidRegion;
import redempt.redlib.region.RegionMap;

public class ProtectionPolicy
implements Listener {
    protected static Set<ProtectionPolicy> globalPolicies = new HashSet<ProtectionPolicy>();
    protected static RegionMap<ProtectionPolicy> regionMap = new RegionMap();
    private List<BypassPolicy> bypassPolicies = new ArrayList<BypassPolicy>();
    private Set<ProtectionType> protections = EnumSet.noneOf(ProtectionType.class);
    private Map<ProtectionType, String> messages = new EnumMap<ProtectionType, String>(ProtectionType.class);
    private Predicate<Block> protectionCheck;
    private CuboidRegion bounds;
    private Plugin plugin;

    public static <T extends Event> void registerProtection(Class<T> clazz, ProtectionType type, Function<T, Player> getPlayer, Function<T, Block> ... getBlocks) {
        ProtectionListener.protect(clazz, type, getPlayer, getBlocks);
    }

    public static <T extends Event> void registerProtectionNonCancellable(Class<T> clazz, ProtectionType type, Function<T, Player> getPlayer, Consumer<T> cancel, Function<T, Block> ... getBlocks) {
        ProtectionListener.protectNonCancellable(clazz, type, getPlayer, cancel, getBlocks);
    }

    public static <T extends Event> void registerProtectionMultiBlock(Class<T> clazz, ProtectionType type, Function<T, Player> getPlayer, BiConsumer<T, Block> cancel, Function<T, List<Block>> getBlocks) {
        ProtectionListener.protectMultiBlock(clazz, type, getPlayer, cancel, getBlocks);
    }

    public static <T extends Event> void registerProtectionDirectional(Class<T> clazz, ProtectionType type, Function<T, Player> getPlayer, Function<T, Block> getActingBlock, Function<T, List<Block>> getSubjectBlocks) {
        ProtectionListener.protectDirectional(clazz, type, getPlayer, getActingBlock, getSubjectBlocks);
    }

    protected ProtectionPolicy(Plugin plugin, CuboidRegion bounds, Predicate<Block> protectionCheck, ProtectionType ... protections) {
        new EventListener<PluginDisableEvent>(RedLib.getInstance(), PluginDisableEvent.class, (l, e) -> {
            if (e.getPlugin().equals((Object)this.plugin)) {
                this.disable();
                l.unregister();
            }
        });
        this.plugin = plugin;
        this.bounds = bounds;
        Arrays.stream(protections).forEach(this.protections::add);
        this.protectionCheck = protectionCheck;
        regionMap.set(bounds, this);
    }

    public ProtectionPolicy(CuboidRegion bounds, Predicate<Block> protectionCheck, ProtectionType ... protections) {
        new EventListener<PluginDisableEvent>(RedLib.getInstance(), PluginDisableEvent.class, (l, e) -> {
            if (e.getPlugin().equals((Object)this.plugin)) {
                this.disable();
                l.unregister();
            }
        });
        this.plugin = RedLib.getCallingPlugin();
        this.bounds = bounds;
        Arrays.stream(protections).forEach(this.protections::add);
        this.protectionCheck = protectionCheck;
        regionMap.set(bounds, this);
    }

    public ProtectionPolicy(Predicate<Block> protectionCheck, ProtectionType ... protections) {
        new EventListener<PluginDisableEvent>(RedLib.getInstance(), PluginDisableEvent.class, (l, e) -> {
            if (e.getPlugin().equals((Object)this.plugin)) {
                this.disable();
                l.unregister();
            }
        });
        this.plugin = RedLib.getCallingPlugin();
        this.protectionCheck = protectionCheck;
        Arrays.stream(protections).forEach(this.protections::add);
        globalPolicies.add(this);
    }

    public void setProtectionTypes(ProtectionType ... protections) {
        this.protections.clear();
        this.addProtectionTypes(protections);
    }

    public void addProtectionTypes(ProtectionType ... protections) {
        Collections.addAll(this.protections, protections);
    }

    public void removeProtectionTypes(ProtectionType ... protections) {
        Arrays.stream(protections).forEach(this.protections::remove);
    }

    public void disable() {
        if (this.bounds == null) {
            globalPolicies.remove(this);
            return;
        }
        regionMap.remove(this.bounds, this);
    }

    public void enable() {
        if (this.bounds == null) {
            globalPolicies.add(this);
            return;
        }
        regionMap.set(this.bounds, this);
    }

    public void addBypassPolicy(BiPredicate<Player, ProtectionType> bypassPolicy) {
        this.bypassPolicies.add((p, t, b) -> bypassPolicy.test(p, t));
    }

    public void addBypassPolicy(BypassPolicy bypassPolicy) {
        this.bypassPolicies.add(bypassPolicy);
    }

    public void clearBypassPolicies() {
        this.bypassPolicies.clear();
    }

    public void setDenyMessage(ProtectionType type, String message) {
        this.messages.put(type, message);
    }

    public void setDenyMessage(Predicate<ProtectionType> filter, String message) {
        Arrays.stream(ProtectionType.values()).filter(filter).forEach(t -> this.messages.put((ProtectionType)((Object)t), message));
    }

    public void clearDenyMessages() {
        this.messages.clear();
    }

    public CuboidRegion getBounds() {
        return this.bounds;
    }

    private boolean canBypass(Player player, ProtectionType type, Block block) {
        return this.bypassPolicies.stream().anyMatch(p -> p.canBypass(player, type, block));
    }

    private void sendMessage(Player player, ProtectionType type) {
        String message = this.messages.get((Object)type);
        if (message != null) {
            player.sendMessage(message);
        }
    }

    public boolean allow(Block block, ProtectionType type, Player player) {
        if (this.protections.contains((Object)type) && this.protectionCheck.test(block)) {
            if (this.canBypass(player, type, block)) {
                return true;
            }
            if (player != null) {
                this.sendMessage(player, type);
            }
            return false;
        }
        return true;
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        if (this.protections.contains((Object)ProtectionType.MOB_SPAWN) && this.protectionCheck.test(e.getLocation().getBlock())) {
            if (this.canBypass(null, ProtectionType.MOB_SPAWN, e.getLocation().getBlock())) {
                return;
            }
            e.setCancelled(true);
        }
    }

    static {
        ProtectionRegistrations.registerProtections();
    }

    public static enum ProtectionType {
        BREAK_BLOCK,
        PLACE_BLOCK,
        INTERACT,
        USE_BUCKETS,
        CONTAINER_ACCESS,
        ENTITY_EXPLOSION,
        BLOCK_EXPLOSION,
        PISTONS,
        PISTONS_IN,
        REDSTONE,
        FALLING_BLOCK,
        GROWTH,
        STRUCTURE_GROWTH,
        STRUCTURE_GROWTH_IN,
        FADE,
        FLOW,
        FLOW_IN,
        ANVIL_BREAK,
        MOB_SPAWN,
        SILVERFISH,
        WITHER,
        FIRE,
        PORTAL_PAIRING,
        ENTITY_FORM_BLOCK,
        MISCELLANEOUS,
        INTERACT_ENTITY,
        PLACE_ENTITY,
        DISPENSER_PLACE,
        DISPENSER_PLACE_IN,
        TRAMPLE;

        public static final ProtectionType[] ALL;
        public static final ProtectionType[] DIRECT_PLAYERS;
        public static final ProtectionType[] INDIRECT_PLAYERS;
        public static final ProtectionType[] NATURAL;

        public static ProtectionType[] allExcept(ProtectionType ... types) {
            EnumSet<ProtectionType> list = EnumSet.noneOf(ProtectionType.class);
            Arrays.stream(ALL).forEach(list::add);
            Arrays.stream(types).forEach(list::remove);
            return list.toArray(new ProtectionType[list.size()]);
        }

        public static ProtectionType[] and(ProtectionType[] ... types) {
            EnumSet<ProtectionType> list = EnumSet.noneOf(ProtectionType.class);
            ProtectionType[][] protectionTypeArray = types;
            int n = protectionTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ProtectionType[] arr;
                for (ProtectionType type : arr = protectionTypeArray[i]) {
                    list.add(type);
                }
            }
            return list.toArray(new ProtectionType[list.size()]);
        }

        static {
            ALL = ProtectionType.values();
            DIRECT_PLAYERS = new ProtectionType[]{BREAK_BLOCK, PLACE_BLOCK, INTERACT, CONTAINER_ACCESS, USE_BUCKETS, ENTITY_FORM_BLOCK, PLACE_ENTITY, INTERACT_ENTITY, TRAMPLE};
            INDIRECT_PLAYERS = new ProtectionType[]{REDSTONE, ENTITY_EXPLOSION, BLOCK_EXPLOSION, FALLING_BLOCK, FIRE, PORTAL_PAIRING, WITHER, FLOW_IN, PISTONS_IN, DISPENSER_PLACE_IN};
            NATURAL = new ProtectionType[]{GROWTH, FADE, FLOW, MOB_SPAWN};
        }
    }
}

