/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.nms;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import redempt.redlib.nms.NMSArray;
import redempt.redlib.nms.NMSHelper;
import redempt.redlib.nms.NMSObject;

public class NMSClass {
    private Class<?> clazz;

    public NMSClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    public String getName() {
        return this.clazz.getSimpleName();
    }

    public Class<?> getWrappedClass() {
        return this.clazz;
    }

    public NMSClass getSuperclass() {
        return new NMSClass(this.clazz.getSuperclass());
    }

    public NMSObject getInstance(Object ... args) {
        try {
            NMSHelper.unwrapArgs(args);
            return new NMSObject(NMSHelper.getConstructor(this.clazz, NMSHelper.getArgTypes(args)).newInstance(args));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public NMSArray createArray(int size) {
        return new NMSArray(Array.newInstance(this.clazz, size));
    }

    public NMSObject callStaticMethod(String methodName, Object ... args) {
        try {
            Method method = NMSHelper.getMethod(this.clazz, methodName, NMSHelper.getArgTypes(args));
            return new NMSObject(method.invoke(null, args));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public NMSObject getStaticField(String name) {
        try {
            Field field = this.clazz.getDeclaredField(name);
            field.setAccessible(true);
            return new NMSObject(field.get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

