/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import redempt.redlib.RedLib;
import redempt.redlib.misc.EventListener;
import redempt.redlib.misc.Task;

public class UserCache {
    private static Map<String, OfflinePlayer> nameCache;
    private static CompletableFuture<Void> initTask;

    public static synchronized void asyncInit(Runnable onComplete) {
        if (initTask != null || nameCache != null) {
            onComplete.run();
            return;
        }
        initTask = CompletableFuture.runAsync(() -> {
            if (nameCache != null) {
                return;
            }
            nameCache = new ConcurrentHashMap<String, OfflinePlayer>();
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                nameCache.put(player.getName().toLowerCase(Locale.ROOT), player);
            }
            Task.syncDelayed(() -> new EventListener<PlayerJoinEvent>(RedLib.getInstance(), PlayerJoinEvent.class, EventPriority.LOWEST, e -> {
                Player player = e.getPlayer();
                nameCache.put(player.getName().toLowerCase(Locale.ROOT), (OfflinePlayer)player);
            }));
        });
    }

    public static void asyncInit() {
        UserCache.asyncInit(() -> {});
    }

    public static void init() {
        UserCache.asyncInit();
        if (!initTask.isDone()) {
            try {
                initTask.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        if (nameCache == null) {
            UserCache.init();
        }
        return nameCache.get(name.toLowerCase(Locale.ROOT));
    }
}

