/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import redempt.redlib.RedLib;

public class ChatPrompt
implements Listener {
    private static Map<Player, Prompt> prompts = new HashMap<Player, Prompt>();

    public static void prompt(Player player, String prompt, boolean showCancelMessage, Consumer<String> onResponse, Consumer<CancelReason> onCancel) {
        Prompt removed = prompts.remove(player);
        if (removed != null) {
            removed.cancel(CancelReason.PROMPT_OVERRIDDEN);
        }
        prompts.put(player, new Prompt(onResponse, onCancel));
        Optional.ofNullable(prompt).ifPresent(arg_0 -> ((Player)player).sendMessage(arg_0));
        if (showCancelMessage) {
            player.sendMessage(RedLib.msg("cancelPromptMessage").replace("%canceltext%", RedLib.msg("cancelText")));
        }
    }

    public static void prompt(Player player, String prompt, boolean showCancelMessage, Consumer<String> onResponse) {
        ChatPrompt.prompt(player, prompt, showCancelMessage, onResponse, c -> {});
    }

    public static void prompt(Player player, String prompt, Consumer<String> onResponse) {
        ChatPrompt.prompt(player, prompt, true, onResponse, c -> {});
    }

    public static void prompt(Player player, String prompt, Consumer<String> onResponse, Consumer<CancelReason> onCancel) {
        ChatPrompt.prompt(player, prompt, true, onResponse, onCancel);
    }

    private ChatPrompt() {
        Bukkit.getPluginManager().registerEvents((Listener)this, RedLib.getInstance());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        Prompt p = prompts.remove(e.getPlayer());
        if (p == null) {
            return;
        }
        e.setCancelled(true);
        if (e.getMessage().equalsIgnoreCase(RedLib.msg("cancelText"))) {
            p.cancel(CancelReason.PLAYER_CANCELLED);
            return;
        }
        p.respond(e.getMessage());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        Prompt p = prompts.remove(e.getPlayer());
        if (p != null) {
            p.cancel(CancelReason.PLAYER_LEFT);
        }
    }

    static {
        new ChatPrompt();
    }

    private static class Prompt {
        private Consumer<String> onResponse;
        private Consumer<CancelReason> onCancel;

        public Prompt(Consumer<String> onResponse, Consumer<CancelReason> onCancel) {
            this.onResponse = onResponse;
            this.onCancel = onCancel;
        }

        public void respond(String response) {
            this.onResponse.accept(response);
        }

        public void cancel(CancelReason reason) {
            this.onCancel.accept(reason);
        }
    }

    public static enum CancelReason {
        PROMPT_OVERRIDDEN,
        PLAYER_CANCELLED,
        PLAYER_LEFT;

    }
}

