/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.itemutils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import redempt.redlib.RedLib;
import redempt.redlib.itemutils.ItemTrait;
import redempt.redlib.itemutils.MockInventory;
import redempt.redlib.json.JSONList;
import redempt.redlib.json.JSONMap;
import redempt.redlib.json.JSONParser;
import redempt.redlib.nms.NMSHelper;

public class ItemUtils {
    private static Material skullType = RedLib.MID_VERSION >= 13 ? Material.valueOf((String)"PLAYER_HEAD") : Material.valueOf((String)"SKULL_ITEM");

    public static ItemStack skull(OfflinePlayer owner) {
        ItemStack base = ItemUtils.getBaseSkull();
        SkullMeta meta = (SkullMeta)base.getItemMeta();
        if (RedLib.MID_VERSION >= 13) {
            meta.setOwningPlayer(owner);
        } else {
            meta.setOwner(owner.getName());
        }
        base.setItemMeta((ItemMeta)meta);
        return base;
    }

    private static ItemStack getBaseSkull() {
        return RedLib.MID_VERSION >= 13 ? new ItemStack(skullType) : new ItemStack(skullType, 1, 3);
    }

    public static ItemStack rename(ItemStack item, String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack setName(ItemStack item, String name) {
        return ItemUtils.rename(item, name);
    }

    public static ItemStack setLore(ItemStack item, String line) {
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(line);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack setLore(ItemStack item, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addLore(ItemStack item, String line) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        lore = lore == null ? new ArrayList() : lore;
        lore.add(line);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addLore(ItemStack item, Iterable<String> lines) {
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        lore = lore == null ? new ArrayList() : lore;
        lines.forEach(lore::add);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack setLore(ItemStack item, String ... lore) {
        return ItemUtils.setLore(item, Arrays.asList(lore));
    }

    public static ItemStack setUnbreakable(ItemStack item) {
        item = item.clone();
        ItemMeta meta = item.getItemMeta();
        meta.setUnbreakable(true);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addEnchant(ItemStack item, Enchantment enchant, int level) {
        ItemMeta meta = item.getItemMeta();
        meta.addEnchant(enchant, level, true);
        if (level == 0) {
            meta.removeEnchant(enchant);
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addAttribute(ItemStack item, Attribute attribute, AttributeModifier modifier) {
        ItemMeta meta = item.getItemMeta();
        meta.addAttributeModifier(attribute, modifier);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addAttribute(ItemStack item, Attribute attribute, double amount, AttributeModifier.Operation operation) {
        ItemMeta meta = item.getItemMeta();
        AttributeModifier modifier = new AttributeModifier(attribute.toString(), amount, operation);
        meta.addAttributeModifier(attribute, modifier);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addItemFlags(ItemStack item, ItemFlag ... flags) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(flags);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack setCustomModelData(ItemStack item, int customModelData) {
        ItemMeta meta = item.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(customModelData));
        item.setItemMeta(meta);
        return item;
    }

    public static <T, Z> ItemStack addPersistentTag(ItemStack item, NamespacedKey key, PersistentDataType<T, Z> type, Z data) {
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(key, type, data);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addAttribute(ItemStack item, Attribute attribute, double amount, AttributeModifier.Operation operation, EquipmentSlot slot) {
        ItemMeta meta = item.getItemMeta();
        AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), attribute.toString(), amount, operation, slot);
        meta.addAttributeModifier(attribute, modifier);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack damage(ItemStack item, int amount) {
        if (RedLib.MID_VERSION >= 13) {
            ItemMeta meta = item.getItemMeta();
            if (!(meta instanceof Damageable)) {
                throw new IllegalArgumentException("Item must be damageable");
            }
            Damageable d = (Damageable)meta;
            d.setDamage(d.getDamage() + amount);
            item.setItemMeta(meta);
            return item;
        }
        item.setDurability((short)(item.getDurability() + amount));
        return item;
    }

    public static int count(Inventory inv, ItemStack item, BiPredicate<ItemStack, ItemStack> comparison) {
        int count = 0;
        for (ItemStack i : inv) {
            if (!comparison.test(item, i)) continue;
            count += i.getAmount();
        }
        return count;
    }

    public static int count(Inventory inv, ItemStack item) {
        return ItemUtils.count(inv, item, ItemStack::isSimilar);
    }

    public static int count(Inventory inv, Material type) {
        return ItemUtils.count(inv, new ItemStack(type), (a, b) -> ItemUtils.compare(a, b, ItemTrait.TYPE));
    }

    public static boolean remove(Inventory inv, ItemStack item, int amount, BiPredicate<ItemStack, ItemStack> comparison) {
        ItemStack[] contents = inv.getContents();
        for (int i = 0; i < contents.length && amount > 0; ++i) {
            if (!comparison.test(item, contents[i])) continue;
            if (amount >= contents[i].getAmount()) {
                contents[i] = null;
                if ((amount -= contents[i].getAmount()) != 0) continue;
                inv.setContents(contents);
                return true;
            }
            contents[i].setAmount(contents[i].getAmount() - amount);
            inv.setContents(contents);
            return true;
        }
        inv.setContents(contents);
        return false;
    }

    public static boolean remove(Inventory inv, ItemStack item, int amount) {
        return ItemUtils.remove(inv, item, amount, ItemStack::isSimilar);
    }

    public static boolean remove(Inventory inv, Material type, int amount) {
        return ItemUtils.remove(inv, new ItemStack(type), amount, (a, b) -> ItemUtils.compare(a, b, ItemTrait.TYPE));
    }

    public static int countAndRemove(Inventory inv, ItemStack item, int max, BiPredicate<ItemStack, ItemStack> comparison) {
        int count = ItemUtils.count(inv, item, comparison);
        count = Math.min(max, count);
        ItemUtils.remove(inv, item, count, comparison);
        return count;
    }

    public static int countAndRemove(Inventory inv, ItemStack item, int max) {
        return ItemUtils.countAndRemove(inv, item, max, ItemStack::isSimilar);
    }

    public static int countAndRemove(Inventory inv, Material type, int max) {
        return ItemUtils.countAndRemove(inv, new ItemStack(type), max, (a, b) -> ItemUtils.compare(a, b, ItemTrait.TYPE));
    }

    public static int countAndRemove(Inventory inv, ItemStack item) {
        return ItemUtils.countAndRemove(inv, item, Integer.MAX_VALUE, ItemStack::isSimilar);
    }

    public static int countAndRemove(Inventory inv, Material type) {
        return ItemUtils.countAndRemove(inv, new ItemStack(type), Integer.MAX_VALUE, (a, b) -> ItemUtils.compare(a, b, ItemTrait.TYPE));
    }

    public static void give(Player player, ItemStack ... items) {
        player.getInventory().addItem(items).values().forEach(i -> player.getWorld().dropItem(player.getLocation(), i));
    }

    public static void give(Player player, ItemStack item, int amount) {
        ItemStack clone;
        if (amount < 1) {
            throw new IllegalArgumentException("Amount must be greater than 0");
        }
        int stackSize = item.getType().getMaxStackSize();
        while (amount > stackSize) {
            clone = item.clone();
            clone.setAmount(stackSize);
            ItemUtils.give(player, clone);
            amount -= stackSize;
        }
        clone = item.clone();
        clone.setAmount(amount);
        ItemUtils.give(player, clone);
    }

    public static void give(Player player, Material type, int amount) {
        ItemUtils.give(player, new ItemStack(type), amount);
    }

    public static boolean compare(ItemStack first, ItemStack second, ItemTrait ... traits) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        for (ItemTrait trait : traits) {
            if (trait.compare(first, second)) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(ItemStack first, ItemStack second) {
        return ItemUtils.compare(first, second, ItemTrait.TYPE, ItemTrait.NAME, ItemTrait.LORE);
    }

    public static Inventory cloneInventory(Inventory inv) {
        ItemStack[] contents = new ItemStack[inv.getSize()];
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null) continue;
            contents[i] = item.clone();
        }
        return new MockInventory(contents, inv.getHolder(), inv.getType());
    }

    public static int minimumChestSize(int items) {
        return (int)Math.max(9.0, Math.ceil((double)items / 9.0) * 9.0);
    }

    public static String toString(ItemStack item) {
        return item == null ? null : ItemUtils.toJSON((ConfigurationSerializable)item, ItemStack.class).toString();
    }

    public static ItemStack fromString(String json) {
        JSONMap jsonMeta;
        JSONMap enchants;
        JSONMap map = JSONParser.parseMap(json);
        ItemStack item = (ItemStack)ItemUtils.deserialize(map);
        ItemMeta meta = item.getItemMeta();
        if (map.containsKey("meta") && (enchants = (jsonMeta = map.getMap("meta")).getMap("enchants")) != null) {
            enchants.forEach((k, v) -> meta.addEnchant(Enchantment.getByName((String)k), ((Integer)v).intValue(), true));
        }
        item.setItemMeta(meta);
        return item;
    }

    private static Object deserialize(JSONMap map) {
        try {
            HashMap dmap = new HashMap();
            map.forEach((k, v) -> {
                if (v instanceof JSONMap) {
                    JSONMap json = (JSONMap)v;
                    if (json.containsKey("==")) {
                        dmap.put(k, ItemUtils.deserialize(json));
                    }
                    return;
                }
                dmap.put(k, v);
            });
            Class clazz = Class.forName(map.getString("==").replace("%version%", NMSHelper.getNMSVersion()));
            DelegateDeserialization annotation = clazz.getAnnotation(DelegateDeserialization.class);
            if (annotation != null) {
                clazz = annotation.value();
            }
            Method deserialize = clazz.getDeclaredMethod("deserialize", Map.class);
            Object o = deserialize.invoke(null, dmap);
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JSONMap toJSON(ConfigurationSerializable s, Class<?> clazz) {
        Map map = s.serialize();
        JSONMap json = new JSONMap();
        json.put("==", clazz.getName().replace(NMSHelper.getNMSVersion(), "%version%"));
        map.forEach((k, v) -> json.put(k, ItemUtils.serialize(v)));
        return json;
    }

    private static Object serialize(Object o) {
        if (o instanceof ConfigurationSerializable) {
            Class<?> clazz = o.getClass();
            return ItemUtils.toJSON((ConfigurationSerializable)o, clazz);
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            JSONMap json = new JSONMap();
            map.forEach((k, v) -> json.put(k.toString(), ItemUtils.serialize(v)));
            return json;
        }
        if (o instanceof List) {
            List list = (List)o;
            JSONList json = new JSONList();
            list.stream().map(ItemUtils::serialize).forEach(json::add);
            return json;
        }
        return o;
    }
}

