/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.inventorygui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import redempt.redlib.RedLib;
import redempt.redlib.inventorygui.ItemButton;
import redempt.redlib.itemutils.ItemBuilder;

public class InventoryGUI
implements Listener {
    public static final ItemStack FILLER = RedLib.MID_VERSION >= 13 ? new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setName(" ") : new ItemBuilder(Material.valueOf((String)"STAINED_GLASS_PANE")).setDurability(7).setName(" ");
    private final Inventory inventory;
    private Set<Integer> openSlots = new LinkedHashSet<Integer>();
    private Runnable onDestroy;
    private BiConsumer<InventoryClickEvent, List<Integer>> onClickOpenSlot = (e, i) -> {};
    private Consumer<InventoryDragEvent> onDragOpenSlot = e -> {};
    private Map<Integer, ItemButton> buttons = new HashMap<Integer, ItemButton>();
    private boolean returnItems = true;
    private boolean destroyOnClose = true;

    public InventoryGUI(Inventory inventory) {
        this.inventory = inventory;
        Bukkit.getPluginManager().registerEvents((Listener)this, RedLib.getInstance());
    }

    public InventoryGUI(int size, String name) {
        this(Bukkit.createInventory(null, (int)size, (String)name));
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void addButton(ItemButton button, int slot) {
        button.setSlot(slot);
        this.inventory.setItem(slot, button.getItem());
        this.buttons.put(slot, button);
    }

    public void addButton(int slot, ItemButton button) {
        this.addButton(button, slot);
    }

    public void addButton(ItemButton button, int x, int y) {
        int slot = x + y * 9;
        this.addButton(button, slot);
    }

    public void fill(int start, int end, ItemStack item) {
        for (int i = start; i < end; ++i) {
            this.inventory.setItem(i, item == null ? null : item.clone());
        }
    }

    public void fill(int x1, int y1, int x2, int y2, ItemStack item) {
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                this.inventory.setItem(x + y * 9, item == null ? null : item.clone());
            }
        }
    }

    public void removeButton(ItemButton button) {
        this.inventory.setItem(button.getSlot(), new ItemStack(Material.AIR));
        this.buttons.remove(button.getSlot());
    }

    public List<ItemButton> getButtons() {
        return new ArrayList<ItemButton>(this.buttons.values());
    }

    public ItemButton getButton(int slot) {
        return this.buttons.get(slot);
    }

    public void clearSlot(int slot) {
        ItemButton button = this.buttons.get(slot);
        if (button != null) {
            this.removeButton(button);
            return;
        }
        this.inventory.setItem(slot, new ItemStack(Material.AIR));
    }

    public void update() {
        for (ItemButton button : this.buttons.values()) {
            this.inventory.setItem(button.getSlot(), button.getItem());
        }
    }

    public void openSlot(int slot) {
        this.openSlots.add(slot);
    }

    public void openSlots(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.openSlots.add(i);
        }
    }

    public void openSlots(int x1, int y1, int x2, int y2) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                this.openSlots.add(y * 9 + x);
            }
        }
    }

    public void closeSlot(int slot) {
        this.openSlots.remove(slot);
    }

    public void closeSlots(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.openSlots.remove(i);
        }
    }

    public void closeSlots(int x1, int y1, int x2, int y2) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                this.openSlots.remove(y * 9 + x);
            }
        }
    }

    public Set<Integer> getOpenSlots() {
        return this.openSlots;
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    public boolean returnsItems() {
        return this.returnItems;
    }

    public void setReturnsItems(boolean returnItems) {
        this.returnItems = returnItems;
    }

    public boolean destroysOnClose() {
        return this.destroyOnClose;
    }

    public void setDestroyOnClose(boolean destroyOnClose) {
        this.destroyOnClose = destroyOnClose;
    }

    public void setOnDestroy(Runnable onDestroy) {
        this.onDestroy = onDestroy;
    }

    public void setOnClickOpenSlot(Consumer<InventoryClickEvent> handler) {
        this.onClickOpenSlot = (e, i) -> handler.accept((InventoryClickEvent)e);
    }

    public void setOnClickOpenSlot(BiConsumer<InventoryClickEvent, List<Integer>> handler) {
        this.onClickOpenSlot = handler;
    }

    public void destroy(Player lastViewer) {
        if (this.onDestroy != null) {
            this.onDestroy.run();
        }
        HandlerList.unregisterAll((Listener)this);
        if (this.returnItems && lastViewer != null) {
            for (int slot : this.openSlots) {
                ItemStack item = this.inventory.getItem(slot);
                if (item == null) continue;
                lastViewer.getInventory().addItem(new ItemStack[]{item}).values().forEach(i -> lastViewer.getWorld().dropItem(lastViewer.getLocation(), i));
            }
        }
        this.inventory.clear();
        this.buttons.clear();
    }

    public void destroy() {
        this.destroy(null);
    }

    public void clear() {
        this.inventory.clear();
        this.buttons.clear();
    }

    public void setOnDragOpenSlot(Consumer<InventoryDragEvent> onDrag) {
        this.onDragOpenSlot = onDrag;
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        List slots = e.getRawSlots().stream().filter(s -> this.getInventory(e.getView(), (int)s).equals((Object)this.inventory)).collect(Collectors.toList());
        if (slots.size() == 0) {
            return;
        }
        if (!this.openSlots.containsAll(slots)) {
            e.setCancelled(true);
            return;
        }
        this.onDragOpenSlot.accept(e);
    }

    private Inventory getInventory(InventoryView view, int rawSlot) {
        return rawSlot < view.getTopInventory().getSize() ? view.getTopInventory() : view.getBottomInventory();
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (!this.inventory.equals((Object)e.getView().getTopInventory())) {
            return;
        }
        if (e.getAction() == InventoryAction.COLLECT_TO_CURSOR && !e.getClickedInventory().equals((Object)this.inventory)) {
            e.setCancelled(true);
            return;
        }
        if (!this.inventory.equals((Object)e.getClickedInventory()) && e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            if (this.openSlots.size() > 0) {
                HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
                int amount = e.getCurrentItem().getAmount();
                for (int slot : this.openSlots) {
                    if (amount <= 0) break;
                    ItemStack item = this.inventory.getItem(slot);
                    if (item == null) {
                        int diff = Math.min(amount, e.getCurrentItem().getType().getMaxStackSize());
                        amount -= diff;
                        ItemStack clone = e.getCurrentItem().clone();
                        clone.setAmount(diff);
                        slots.put(slot, clone);
                        continue;
                    }
                    if (!e.getCurrentItem().isSimilar(item)) continue;
                    int max = item.getType().getMaxStackSize() - item.getAmount();
                    int diff = Math.min(max, e.getCurrentItem().getAmount());
                    amount -= diff;
                    ItemStack clone = item.clone();
                    clone.setAmount(clone.getAmount() + diff);
                    slots.put(slot, clone);
                }
                if (slots.size() == 0) {
                    return;
                }
                this.onClickOpenSlot.accept(e, new ArrayList(slots.keySet()));
                if (e.isCancelled()) {
                    return;
                }
                e.setCancelled(true);
                ItemStack item = e.getCurrentItem();
                item.setAmount(amount);
                e.setCurrentItem(item);
                slots.forEach((arg_0, arg_1) -> ((Inventory)this.inventory).setItem(arg_0, arg_1));
                Bukkit.getScheduler().scheduleSyncDelayedTask(RedLib.getInstance(), () -> ((Player)e.getWhoClicked()).updateInventory());
                return;
            }
            e.setCancelled(true);
        }
        if (e.getInventory().equals((Object)e.getClickedInventory())) {
            if (this.openSlots.contains(e.getSlot())) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(e.getSlot());
                this.onClickOpenSlot.accept(e, list);
                return;
            }
            e.setCancelled(true);
            ItemButton button = this.buttons.get(e.getSlot());
            if (button != null) {
                button.onClick(e);
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory().equals((Object)this.inventory) && this.destroyOnClose && e.getViewers().size() <= 1) {
            this.destroy((Player)e.getPlayer());
        }
    }
}

