/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.enchants.events;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import redempt.redlib.RedLib;
import redempt.redlib.misc.Task;

public class PlayerChangedArmorEvent
extends PlayerEvent {
    private static HandlerList handlers = new HandlerList();
    private ItemStack[] previous;
    private ItemStack[] current;

    public static HandlerList getHandlerList() {
        return handlers;
    }

    private static void register() {
        Task.syncRepeating(RedLib.getInstance(), () -> Bukkit.getOnlinePlayers().forEach(PlayerChangedArmorEvent::check), 1L, 1L);
    }

    private static void check(Player player) {
        ItemStack[] armor = (ItemStack[])player.getInventory().getArmorContents().clone();
        Task.syncDelayed(RedLib.getInstance(), () -> {
            ItemStack[] newArmor = player.getInventory().getArmorContents();
            for (int i = 0; i < armor.length; ++i) {
                if (armor[i] == null && newArmor[i] == null || armor[i] != null && newArmor[i] != null && armor[i].equals((Object)newArmor[i])) continue;
                Bukkit.getPluginManager().callEvent((Event)new PlayerChangedArmorEvent(player, armor, newArmor));
            }
        }, 1L);
    }

    public PlayerChangedArmorEvent(Player player, ItemStack[] previous, ItemStack[] current) {
        super(player);
        this.previous = previous;
        this.current = current;
    }

    public ItemStack[] getPreviousArmor() {
        return this.previous;
    }

    public ItemStack[] getNewArmor() {
        return this.current;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    static {
        PlayerChangedArmorEvent.register();
    }
}

