/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.configmanager;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import redempt.redlib.configmanager.ConfigField;
import redempt.redlib.configmanager.ConfigManager;
import redempt.redlib.configmanager.ConversionType;
import redempt.redlib.configmanager.TypeConverter;
import redempt.redlib.configmanager.annotations.ConfigPath;
import redempt.redlib.configmanager.annotations.ConfigPostInit;
import redempt.redlib.configmanager.annotations.ConfigValue;
import redempt.redlib.configmanager.exceptions.ConfigMapException;

class ConfigObjectMapper<T> {
    private Class<T> clazz;
    private List<ConfigField> fields = new ArrayList<ConfigField>();
    private TypeConverter<T> converter;
    private Field pathField;
    private boolean pathFieldString = false;
    private Method postInit;
    private ConversionType type;

    public ConfigObjectMapper(Class<T> clazz, ConversionType type, ConfigManager manager) {
        this.clazz = clazz;
        if (type == ConversionType.AUTO) {
            type = ConversionType.auto(clazz, manager);
        }
        this.type = type;
        switch (type) {
            case MAPPED_OBJECT: {
                for (Field field : clazz.getDeclaredFields()) {
                    if (field.isAnnotationPresent(ConfigPath.class)) {
                        this.pathField = field;
                        this.pathField.setAccessible(true);
                        if (field.getType().equals(String.class)) {
                            this.pathFieldString = true;
                            continue;
                        }
                        if (field.getType().equals(ConfigurationSection.class)) continue;
                        throw new ConfigMapException("Field annotated with @ConfigPath must be of type String or ConfigurationSection!");
                    }
                    ConfigValue hook = field.getAnnotation(ConfigValue.class);
                    if (hook == null) continue;
                    String value = hook.value();
                    value = value.length() == 0 ? field.getName() : value;
                    this.fields.add(new ConfigField(hook.type(), field, value, hook.priority(), manager));
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    if (!accessibleObject.isAnnotationPresent(ConfigPostInit.class)) continue;
                    if (((Method)accessibleObject).getParameterCount() != 0) {
                        throw new ConfigMapException("Post-init method must take no arguments");
                    }
                    this.postInit = accessibleObject;
                    this.postInit.setAccessible(true);
                    break;
                }
                this.fields.sort(Comparator.comparingInt(f -> f.priority));
                break;
            }
            case STRING_CONVERTED: {
                this.converter = manager.getConverter(clazz);
                if (this.converter != null) break;
                throw new ConfigMapException("No type converter for " + clazz.getName());
            }
        }
    }

    public T load(ConfigurationSection section, String path) {
        switch (this.type) {
            case MAPPED_OBJECT: {
                return this.loadMapped(section.getConfigurationSection(path));
            }
            case STRING_CONVERTED: {
                return this.converter.load(section.getString(path));
            }
            case PLAIN: {
                return (T)section.get(path);
            }
        }
        return null;
    }

    private T loadMapped(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        try {
            Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object inst = constructor.newInstance(new Object[0]);
            this.fields.forEach(f -> f.load(inst, section));
            this.setPathField(inst, section);
            if (this.postInit != null) {
                this.postInit.invoke(inst, new Object[0]);
            }
            return inst;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            throw new ConfigMapException("Class " + this.clazz.getName() + " must have a no-arg constructor");
        }
        return null;
    }

    public void save(ConfigurationSection section, String path, T inst) {
        switch (this.type) {
            case MAPPED_OBJECT: {
                this.saveMapped(section.createSection(path), inst);
                break;
            }
            case STRING_CONVERTED: {
                section.set(path, (Object)this.converter.save(inst));
                break;
            }
            case PLAIN: {
                section.set(path, inst);
            }
        }
    }

    private void saveMapped(ConfigurationSection section, T inst) {
        if (inst == null) {
            return;
        }
        this.fields.forEach(f -> f.save(inst, section));
    }

    public ConversionType getType() {
        return this.type;
    }

    public void setPathField(T inst, ConfigurationSection section) {
        if (this.pathField == null) {
            return;
        }
        try {
            this.pathField.set(inst, this.pathFieldString ? section.getName() : section);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

