/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.configmanager;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import redempt.redlib.configmanager.ConfigManager;
import redempt.redlib.configmanager.ConfigObjectMapper;
import redempt.redlib.configmanager.ConfigStorage;
import redempt.redlib.configmanager.ConversionType;
import redempt.redlib.configmanager.TypeConverter;
import redempt.redlib.configmanager.exceptions.ConfigFieldException;

class ConfigField {
    private Field field;
    private String path;
    private ConfigManager manager;
    private ConversionType type;
    private ConfigObjectMapper<?> mapper;
    protected TypeConverter<?> converter;
    protected int priority;

    public ConfigField(ConversionType type, Field field, String path, int priority, ConfigManager manager) {
        if (type == ConversionType.AUTO) {
            type = ConversionType.auto(field.getType(), manager);
        }
        if (type == ConversionType.MAPPED_OBJECT) {
            this.mapper = new ConfigObjectMapper(field.getType(), ConversionType.MAPPED_OBJECT, manager);
        }
        this.type = type;
        this.field = field;
        this.path = path;
        this.priority = priority;
        this.manager = manager;
        this.converter = manager.getConverter(field.getType());
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            throw new ConfigFieldException("Config hook field may not be final!");
        }
    }

    public <T> void load(Object object, ConfigurationSection config) {
        try {
            if (this.field.get(object) instanceof ConfigStorage) {
                ConfigStorage storage = (ConfigStorage)this.field.get(object);
                storage.init(this.manager);
                ConfigurationSection section = config.getConfigurationSection(this.path);
                if (section == null) {
                    return;
                }
                storage.load(section);
                this.field.set(object, storage);
                return;
            }
            if (Map.class.isAssignableFrom(this.field.getType())) {
                Map map = (Map)this.field.get(object);
                ConfigurationSection section = config.getConfigurationSection(this.path);
                if (section == null) {
                    return;
                }
                section.getKeys(false).forEach(k -> map.put(k, section.get(k)));
                return;
            }
            Object value = this.converter != null ? this.converter.load(config.getString(this.path)) : (this.type == ConversionType.MAPPED_OBJECT ? this.mapper.load(config, this.path) : config.get(this.path));
            if (value != null) {
                this.field.set(object, value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void save(Object object, ConfigurationSection config) {
        try {
            if (this.field.get(object) instanceof ConfigStorage) {
                ConfigStorage storage = (ConfigStorage)this.field.get(object);
                storage.init(this.manager);
                ConfigurationSection section = config.createSection(this.path);
                storage.save(section);
                return;
            }
            Object value = this.field.get(object);
            if (this.converter != null) {
                value = this.converter.save(value);
            }
            if (this.type == ConversionType.MAPPED_OBJECT) {
                this.saveMapped(this.mapper, config, this.path, value);
                return;
            }
            config.set(this.path, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private <T> void saveMapped(ConfigObjectMapper<T> mapper, ConfigurationSection section, String path, Object value) {
        mapper.save(section, path, value);
    }

    public void saveIfAbsent(Object object, ConfigurationSection config) {
        try {
            if (!config.isSet(this.path) && this.field.get(object) != null) {
                this.save(object, config);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public String getPath() {
        return this.path;
    }
}

