/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager.processing;

import java.util.Arrays;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import redempt.redlib.commandmanager.ArgType;
import redempt.redlib.commandmanager.Constraint;
import redempt.redlib.commandmanager.processing.CommandParameter;

public class CommandFlag
implements CommandParameter {
    private ArgType<?> type;
    private String name;
    private Constraint<?> constraint;
    private String[] names;
    private int pos;
    private Function<CommandSender, Object> defaultValue = null;
    private boolean contextDefault;

    public CommandFlag(ArgType<?> type, String name, Constraint<?> constraint, int pos, Function<CommandSender, Object> defaultValue, boolean contextDefault) {
        this.type = type;
        this.name = name;
        this.constraint = constraint;
        this.names = name.split(",");
        this.pos = pos;
        this.defaultValue = defaultValue;
        this.contextDefault = contextDefault;
    }

    public Object getDefaultValue(CommandSender sender) {
        return this.defaultValue == null ? null : this.defaultValue.apply(sender);
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public Constraint<?> getConstraint() {
        return this.constraint;
    }

    @Override
    public String getTypeName() {
        return this.type.getName();
    }

    @Override
    public ArgType<?> getType() {
        return this.type;
    }

    public boolean isContextDefault() {
        return this.contextDefault;
    }

    public boolean nameMatches(String name) {
        return Arrays.stream(this.names).anyMatch(name::equals);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getNames() {
        return this.names;
    }

    public String toString() {
        return "[" + this.name + (this.type.getName().equals("boolean") ? "]" : " " + this.type.getName() + "]");
    }
}

