/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.commandmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import redempt.redlib.commandmanager.Command;
import redempt.redlib.commandmanager.processing.CommandProcessUtils;
import redempt.redlib.commandmanager.processing.Result;

public class CommandCollection {
    private List<Command> commands;

    public CommandCollection(List<Command> commands) {
        this.commands = commands;
    }

    public void register(Plugin plugin, String prefix, Object ... listeners) {
        this.mergeBaseCommands();
        this.commands.forEach(c -> {
            c.plugin = plugin;
            c.register(prefix, listeners);
        });
    }

    public void register(String prefix, Object ... listeners) {
        this.register(CommandProcessUtils.getCallingPlugin(), prefix, listeners);
    }

    private void mergeBaseCommands() {
        HashMap<String, List> names = new HashMap<String, List>();
        for (Command command : this.commands) {
            String name = String.join((CharSequence)", ", command.getAliases());
            List cmds = names.getOrDefault(name, new ArrayList());
            cmds.add(command);
            names.put(name, cmds);
        }
        names.forEach((k, v) -> {
            if (v.size() > 1) {
                this.commands.removeAll((Collection<?>)v);
                this.commands.add(new MergedBaseCommand((List<Command>)v));
            }
        });
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void showHelp(String hookName, CommandSender sender) {
        Command result = this.getByHookName(hookName);
        if (result == null) {
            throw new IllegalArgumentException("No command by that hook name exists!");
        }
        result.showHelp(sender);
    }

    public Command getByHookName(String hookName) {
        for (Command command : this.commands) {
            Command result = this.getByHookName(hookName, command);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Command getByHookName(String hookName, Command base) {
        if (hookName.equals(base.hook)) {
            return base;
        }
        for (Command child : base.children) {
            Command result = this.getByHookName(hookName, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected static class MergedBaseCommand
    extends Command {
        public MergedBaseCommand(List<Command> commands) {
            this.children = commands;
            this.help = commands.get((int)0).help;
            this.names = commands.get((int)0).names;
            for (Command command : this.children) {
                command.topLevel = false;
                command.parent = this;
            }
        }

        @Override
        public Result<Boolean, String> execute(CommandSender sender, String[] args, List<Object> prepend) {
            ArrayList results = new ArrayList();
            for (Command cmd : this.children) {
                Result<Boolean, String> result = cmd.execute(sender, args, prepend);
                if (result.getValue().booleanValue()) {
                    return null;
                }
                results.add(result);
            }
            Result message = CommandProcessUtils.getDeepest(results);
            if (message != null) {
                if (message.getMessage() != null) {
                    sender.sendMessage((String)message.getMessage());
                }
                message.getCommand().showHelp(sender);
                return null;
            }
            sender.sendMessage(CommandProcessUtils.msg("helpTitle").replace("%cmdname%", ((Command)this.children.get(0)).getName()));
            sender.sendMessage(this.getHelpRecursive(sender, 0));
            return null;
        }

        @Override
        public String getHelpRecursive(CommandSender sender, int level) {
            return this.children.stream().map(c -> c.getHelpRecursive(sender, 1)).collect(Collectors.joining("\n"));
        }

        @Override
        public List<String> tab(CommandSender sender, String[] args) {
            ArrayList<String> completions = new ArrayList<String>();
            this.children.forEach(c -> completions.addAll(c.tab(sender, args)));
            return completions;
        }

        @Override
        public void register(String prefix, Object ... listeners) {
            super.register(prefix, listeners);
            Map<String, Command.MethodHook> hooks = this.createHookMap(listeners);
            for (Command command : this.children) {
                command.registerHook(hooks, this.plugin);
            }
        }
    }
}

