/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.World;
import org.bukkit.block.Block;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.json.JSONList;
import redempt.redlib.json.JSONMap;
import redempt.redlib.misc.LocationUtils;

public class DataBlock {
    protected JSONMap data = new JSONMap();
    private Map<String, Object> transientProperties = new HashMap<String, Object>();
    protected boolean exists = false;
    private Block block;
    private BlockDataManager manager;
    private boolean modified;

    protected DataBlock(Block block, BlockDataManager manager) {
        this.block = block;
        this.manager = manager;
    }

    public Object getTransientProperty(String key) {
        return this.transientProperties.get(key);
    }

    public void removeTransientProperty(String key) {
        this.transientProperties.remove(key);
    }

    public void setTransientProperty(String key, Object o) {
        this.transientProperties.put(key, o);
    }

    public void setTransientPropertyIfAbsent(String key, Object o) {
        if (!this.containsTransientProperty(key)) {
            this.transientProperties.put(key, o);
        }
    }

    public boolean containsTransientProperty(String key) {
        return this.transientProperties.containsKey(key);
    }

    public void set(String key, Object data) {
        this.modified = true;
        if (data == null) {
            this.remove(key);
            return;
        }
        this.data.put(key, data);
        if (!this.exists) {
            this.save();
        }
    }

    public void setIfAbsent(String key, Object data) {
        if (!this.contains(key)) {
            this.set(key, data);
        }
    }

    protected void setData(JSONMap data) {
        this.data = data;
        this.modified = true;
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public int getInt(String key) {
        return this.data.getInt(key);
    }

    public String getString(String key) {
        return this.data.getString(key);
    }

    public boolean getBoolean(String key) {
        return this.data.getBoolean(key);
    }

    public double getDouble(String key) {
        return this.data.getDouble(key);
    }

    public long getLong(String key) {
        return this.data.getLong(key);
    }

    public JSONMap getMap(String key) {
        return this.data.getMap(key);
    }

    public JSONList getList(String key) {
        return this.data.getList(key);
    }

    public void remove(String key) {
        this.data.remove(key);
        this.modified = true;
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public void clear() {
        this.data.clear();
        this.modified = true;
    }

    public void move(Block block) {
        this.remove();
        this.block = block;
        this.manager.register(this);
        this.exists = false;
        this.modified = true;
        this.save();
    }

    public JSONMap getData() {
        return this.data;
    }

    protected void save() {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        if (this.exists) {
            this.manager.sql.execute("UPDATE blocks SET data=? WHERE x=? AND y=? AND z=? AND world=?;", this.data.toString(), this.block.getX(), this.block.getY(), this.block.getZ(), this.getWorld().getName());
            return;
        }
        int[] pos = this.getChunkCoordinates();
        this.manager.sql.execute("INSERT INTO blocks VALUES (?, ?, ?, ?, ?, ?, ?);", this.getWorld().getName(), pos[0], pos[1], this.block.getX(), this.block.getY(), this.block.getZ(), this.data.toString());
        this.exists = true;
    }

    public boolean isLoaded() {
        int[] pos = this.getChunkCoordinates();
        return this.getWorld().isChunkLoaded(pos[0], pos[1]);
    }

    public int[] getChunkCoordinates() {
        return LocationUtils.getChunkCoordinates(this.block.getLocation());
    }

    public World getWorld() {
        return this.block.getWorld();
    }

    public void remove() {
        this.manager.remove(this);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockDataManager getManager() {
        return this.manager;
    }

    public int hashCode() {
        return Objects.hash(this.block, this.manager);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataBlock)) {
            return false;
        }
        return ((DataBlock)o).block.equals((Object)this.block);
    }
}

