/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.blockdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import redempt.redlib.RedLib;
import redempt.redlib.blockdata.BlockDataManager;
import redempt.redlib.blockdata.CustomBlock;
import redempt.redlib.blockdata.CustomBlockType;
import redempt.redlib.blockdata.DataBlock;
import redempt.redlib.blockdata.events.CustomBlockPlaceEvent;
import redempt.redlib.blockdata.events.DataBlockDestroyEvent;
import redempt.redlib.misc.Path;
import redempt.redlib.nms.NMSHelper;

public class CustomBlockRegistry
implements Listener {
    private static List<CustomBlockRegistry> registries = new ArrayList<CustomBlockRegistry>();
    private BlockDataManager manager;
    private Map<String, CustomBlockType<?>> types = new HashMap();
    private Map<String, CustomBlockType<?>> byItemName = new HashMap();
    private Plugin plugin;

    public static List<CustomBlockRegistry> getAllRegistries() {
        return registries;
    }

    public CustomBlockRegistry(BlockDataManager manager) {
        this.manager = manager;
        registries.add(this);
    }

    public CustomBlockRegistry(BlockDataManager manager, Plugin plugin) {
        this.manager = manager;
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        registries.add(this);
    }

    public BlockDataManager getManager() {
        return this.manager;
    }

    /*
     * Exception decompiling
     */
    public void registerAll(Plugin plugin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void register(CustomBlockType<?> type) {
        String name = type.getBaseItemName();
        this.byItemName.put(name, type);
        type.register(this.manager);
        this.types.put(type.getName(), type);
    }

    public CustomBlockType<?> getByName(String name) {
        return this.types.get(name);
    }

    public Collection<CustomBlockType<?>> getTypes() {
        return this.types.values();
    }

    public <T extends CustomBlock> T getCustomBlock(Block block) {
        DataBlock db = this.manager.getExisting(block);
        if (db == null) {
            return null;
        }
        String type = db.getString("custom-type");
        CustomBlockType<?> ctype = this.types.get(type);
        if (ctype == null) {
            return null;
        }
        return (T)ctype.get(block);
    }

    @EventHandler
    public void onClick(PlayerInteractEvent e) {
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Object cb = this.getCustomBlock(block);
        if (cb != null) {
            ((CustomBlock)cb).click(e);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public <T extends CustomBlock> void onPlace(BlockPlaceEvent e) {
        ItemStack item;
        DataBlock db = this.manager.getExisting(e.getBlock());
        if (db != null) {
            db.remove();
        }
        if ((item = e.getItemInHand()) == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = item.getItemMeta().getDisplayName();
        CustomBlockType<?> type = this.byItemName.get(name);
        if (type == null) {
            return;
        }
        if (type.typeMatches(e.getBlock().getType()) && type.itemMatches(e.getItemInHand())) {
            CustomBlockPlaceEvent place = new CustomBlockPlaceEvent(e.getBlock(), e.getItemInHand(), type, e.getPlayer());
            Bukkit.getPluginManager().callEvent((Event)place);
            if (place.isCancelled()) {
                e.setCancelled(true);
                return;
            }
            type.place(e.getPlayer(), e.getItemInHand(), type.initialize(e.getBlock()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public <T extends CustomBlock> void onBreak(DataBlockDestroyEvent e) {
        if (e.getCause() == DataBlockDestroyEvent.DestroyCause.PLAYER) {
            if (e.getPlayer().getGameMode() == GameMode.CREATIVE) {
                return;
            }
            T cb = this.getCustomBlock(e.getBlock());
            if (cb == null) {
                return;
            }
            CustomBlockType<?> type = ((CustomBlock)cb).getType();
            DataBlock db = e.getDataBlock();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            Object custom = type.get(db);
            items.add(type.getItem(custom));
            items.addAll(type.getDrops(custom));
            if (RedLib.MID_VERSION >= 12) {
                BlockBreakEvent parent = (BlockBreakEvent)e.getParent();
                if (!parent.isDropItems()) {
                    return;
                }
                BlockState state = e.getBlock().getState();
                parent.setDropItems(false);
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
                    ArrayList drops = new ArrayList();
                    items.forEach(item -> drops.add(e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), item)));
                    Event event = (Event)NMSHelper.getClass("org.bukkit.event.block.BlockDropItemEvent").getInstance(e.getBlock(), state, e.getPlayer(), drops).getObject();
                    Bukkit.getPluginManager().callEvent(event);
                    if (((Cancellable)event).isCancelled()) {
                        drops.forEach(Entity::remove);
                    }
                });
            } else {
                Collection drops = e.getBlock().getDrops(e.getPlayer().getItemInHand());
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
                    e.getBlock().getWorld().getNearbyEntities(e.getBlock().getLocation().add(0.5, 0.5, 0.5), 1.0, 1.0, 1.0).stream().filter(en -> en instanceof Item && en.getTicksLived() < 2).map(en -> (Item)en).filter(i -> drops.stream().anyMatch(it -> it.isSimilar(i.getItemStack()))).forEach(Entity::remove);
                    items.forEach(item -> e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation().add(0.5, 0.5, 0.5), item));
                });
            }
        }
    }

    @EventHandler
    public <T extends CustomBlock> void onPickBlock(InventoryCreativeEvent e) {
        Object cb;
        if (e.getCursor() == null || e.getCursor().getType() == Material.AIR || e.getSlot() > 8 || e.getView().getTopInventory().getType() != InventoryType.CRAFTING || e.getCursor().getAmount() != 1 || e.getAction() != InventoryAction.PLACE_ALL) {
            return;
        }
        List<Location> path = Path.getPath(e.getWhoClicked().getEyeLocation(), e.getWhoClicked().getLocation().getDirection(), 5.0);
        Block block = null;
        for (Location loc : path) {
            if (loc.getBlock().getType() == Material.AIR) continue;
            block = loc.getBlock();
            break;
        }
        if (block == null) {
            return;
        }
        if (block.getType() == e.getCursor().getType() && (cb = this.getCustomBlock(block)) != null) {
            e.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, () -> {
                CustomBlockType<?> type = cb.getType();
                ItemStack item = type.getItem(cb);
                for (int i = 0; i < 9; ++i) {
                    if (!item.isSimilar(e.getWhoClicked().getInventory().getItem(i))) continue;
                    e.getWhoClicked().getInventory().setHeldItemSlot(i);
                    return;
                }
                e.getWhoClicked().getInventory().setItem(e.getSlot(), item);
            });
        }
    }

    @EventHandler
    public void onDisable(PluginDisableEvent e) {
        if (e.getPlugin().equals((Object)this.plugin)) {
            registries.remove(this);
        }
    }
}

