/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import redempt.redlib.region.CuboidRegion;
import redempt.redlib.region.MultiRegion;

public class RegionUtils {
    public static MultiRegion findInside(CuboidRegion region) {
        int[] dim = region.getBlockDimensions();
        MultiRegion multi = null;
        multi = RegionUtils.addAll(multi, RegionUtils.iter(region, dim, new int[]{0, 1, 2}));
        multi = RegionUtils.addAll(multi, RegionUtils.iter(region, dim, new int[]{0, 2, 1}));
        if ((multi = RegionUtils.addAll(multi, RegionUtils.iter(region, dim, new int[]{2, 1, 0}))) != null) {
            multi.recalculate();
        }
        return multi;
    }

    private static MultiRegion addAll(MultiRegion region, List<CuboidRegion> reg) {
        int count = 0;
        for (CuboidRegion r : reg) {
            ++count;
            if (region == null) {
                region = new MultiRegion(r);
                continue;
            }
            region.add(r);
            if (count < 10) continue;
            region.recalculate();
            count = 0;
        }
        return region;
    }

    private static List<CuboidRegion> iter(CuboidRegion region, int[] dim, int[] order) {
        int[] pos = new int[3];
        ArrayList<CuboidRegion> regions = new ArrayList<CuboidRegion>();
        pos[order[0]] = 0;
        while (pos[order[0]] < dim[order[0]]) {
            pos[order[1]] = 0;
            while (pos[order[1]] < dim[order[1]]) {
                Block b;
                Block block = null;
                pos[order[2]] = 0;
                while (pos[order[2]] < dim[order[2]]) {
                    b = region.getStart().getBlock().getRelative(pos[0], pos[1], pos[2]);
                    if (b.getType().isSolid()) {
                        block = b;
                        break;
                    }
                    int n = order[2];
                    pos[n] = pos[n] + 1;
                }
                if (block != null) {
                    pos[order[2]] = dim[order[2]] - 1;
                    while (pos[order[2]] >= 0 && !(b = region.getStart().getBlock().getRelative(pos[0], pos[1], pos[2])).equals((Object)block)) {
                        if (b.getType().isSolid()) {
                            CuboidRegion reg = new CuboidRegion(block.getLocation(), b.getLocation());
                            reg.expand(1.0, 0.0, 1.0, 0.0, 1.0, 0.0);
                            regions.add(reg);
                            break;
                        }
                        int n = order[2];
                        pos[n] = pos[n] - 1;
                    }
                }
                int n = order[1];
                pos[n] = pos[n] + 1;
            }
            int n = order[0];
            pos[n] = pos[n] + 1;
        }
        return regions;
    }
}

