/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib;

import java.io.File;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import redempt.redlib.RedLibConfig;
import redempt.redlib.commandmanager.ArgType;
import redempt.redlib.commandmanager.CommandParser;
import redempt.redlib.commandmanager.Messages;
import redempt.redlib.config.ConfigManager;
import redempt.redlib.dev.ChainCommand;
import redempt.redlib.dev.StructureTool;
import redempt.redlib.dev.profiler.ProfilerCommands;

public class RedLib
extends JavaPlugin {
    private static Messages globalMessages;
    private static RedLib redLib;
    public static final int MID_VERSION;

    public static String msg(String msg) {
        return globalMessages.get(msg);
    }

    public static Plugin getInstance() {
        return redLib != null ? redLib : JavaPlugin.getProvidingPlugin(RedLib.class);
    }

    private static int getMidVersion() {
        Pattern pattern = Pattern.compile("1\\.([0-9]+)");
        Matcher matcher = pattern.matcher(Bukkit.getBukkitVersion());
        matcher.find();
        return Integer.parseInt(matcher.group(1));
    }

    public void onLoad() {
        redLib = this;
    }

    public void onEnable() {
        ConfigManager.create((Plugin)this).target(RedLibConfig.class).load();
        if (RedLibConfig.devMode) {
            ChainCommand chain = new ChainCommand();
            new CommandParser(this.getResource("command.rdcml")).setArgTypes(ArgType.of("material", Material.class), chain.getArgType()).parse().register("redlib", new ProfilerCommands(), StructureTool.enable(), chain);
        }
    }

    public static String getServerVersion() {
        String version = Bukkit.getVersion();
        String[] split = version.split(" ");
        return split[split.length - 1].trim().replace(")", "");
    }

    public static Plugin getCallingPlugin() {
        Exception ex = new Exception();
        try {
            Class<?> clazz = Class.forName(ex.getStackTrace()[2].getClassName());
            JavaPlugin plugin = JavaPlugin.getProvidingPlugin(clazz);
            return plugin.isEnabled() ? plugin : Bukkit.getPluginManager().getPlugin(plugin.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<Class<? extends T>> getExtendingClasses(Plugin plugin, Class<T> clazz) {
        ArrayList<Class<T>> list = new ArrayList<Class<T>>();
        try {
            ClassLoader loader = plugin.getClass().getClassLoader();
            JarFile file = new JarFile(new File(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()));
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                Class<?> c;
                String name;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6).replace("/", ".");
                try {
                    c = Class.forName(name, true, loader);
                }
                catch (ClassNotFoundException | NoClassDefFoundError ex) {
                    continue;
                }
                if (!clazz.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers()) || c.isInterface()) continue;
                list.add(c);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return list;
    }

    static {
        Path path = Paths.get("plugins/RedLib/messages.txt", new String[0]);
        globalMessages = Messages.load(RedLib.class.getClassLoader().getResourceAsStream("redlib/messages.txt"), path);
        MID_VERSION = RedLib.getMidVersion();
    }
}

