/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.worldgen;

import java.util.Random;
import redempt.redlib.worldgen.NoiseGenerator;

public class NoiseOctave {
    private NoiseGenerator[] noise;
    private double weight = 0.0;

    public NoiseOctave(long seed, int size) {
        this.noise = new NoiseGenerator[size];
        for (int i = 0; i < size; ++i) {
            this.noise[i] = new NoiseGenerator(seed + (long)i);
        }
        this.weight = size;
    }

    public void setSeed(long seed) {
        for (int i = 0; i < this.noise.length; ++i) {
            this.noise[i].setSeed(seed + (long)i);
        }
    }

    public NoiseOctave(int size) {
        this(new Random().nextLong(), size);
    }

    public int size() {
        return this.noise.length;
    }

    public void setScales(double ... scales) {
        if (scales.length != this.noise.length) {
            throw new IllegalArgumentException("Number of scales passed is not equal to size of NoiseOctave");
        }
        for (int i = 0; i < this.noise.length; ++i) {
            this.noise[i].setScale(scales[i]);
        }
    }

    public void setWeights(double ... weights) {
        if (weights.length != this.noise.length) {
            throw new IllegalArgumentException("Number of weights passed is not equal to size of NoiseOctave");
        }
        double total = 0.0;
        for (int i = 0; i < this.noise.length; ++i) {
            this.noise[i].setWeight(weights[i]);
            total += weights[i];
        }
        this.weight = total;
    }

    public void prefill(int x, int z, int width, int length) {
        for (NoiseGenerator gen : this.noise) {
            gen.prefill(x, z, width, length);
        }
    }

    public void prefill(int x, int y, int z, int width, int height, int length) {
        for (NoiseGenerator gen : this.noise) {
            gen.prefill(x, y, z, width, height, length);
        }
    }

    public double noise(double x, double z) {
        double sum = 0.0;
        for (NoiseGenerator gen : this.noise) {
            sum += gen.noise(x, z);
        }
        return sum / this.weight;
    }

    public double noise(double x, double y, double z) {
        double sum = 0.0;
        for (NoiseGenerator gen : this.noise) {
            sum += gen.noise(x, y, z);
        }
        return sum / this.weight;
    }
}

