/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.misc;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import redempt.redlib.RedLib;
import redempt.redlib.misc.EventListener;
import redempt.redlib.misc.Task;

public class UserCache {
    private static Map<String, OfflinePlayer> nameCache;

    public static void asyncInit(Runnable onComplete) {
        Task.asyncDelayed(() -> {
            UserCache.init();
            onComplete.run();
        });
    }

    public static void asyncInit() {
        UserCache.asyncInit(() -> {});
    }

    public static void init() {
        if (nameCache != null) {
            return;
        }
        nameCache = new ConcurrentHashMap<String, OfflinePlayer>();
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            nameCache.put(player.getName().toLowerCase(Locale.ROOT), player);
        }
        new EventListener<PlayerJoinEvent>(RedLib.getInstance(), PlayerJoinEvent.class, EventPriority.LOWEST, e -> {
            Player player = e.getPlayer();
            nameCache.put(player.getName().toLowerCase(Locale.ROOT), (OfflinePlayer)player);
        });
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        return nameCache.get(name.toLowerCase(Locale.ROOT));
    }
}

