/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.region;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import redempt.redlib.region.CuboidRegion;

public class RegionMap<T> {
    private Map<Coordinate, Set<T>> map = new HashMap<Coordinate, Set<T>>();
    private int scale;

    public RegionMap() {
        this(100);
    }

    public RegionMap(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public void set(CuboidRegion region, T object) {
        Coordinate start = new Coordinate(region.getStart(), this.scale);
        Coordinate end = new Coordinate(region.getEnd(), this.scale);
        for (int x = start.getX(); x <= end.getX(); ++x) {
            for (int z = start.getZ(); z <= end.getZ(); ++z) {
                Coordinate coord = new Coordinate(start.getWorld(), x, z);
                Set<T> list = this.map.get(coord);
                if (list == null) {
                    list = new HashSet<T>();
                }
                list.add(object);
                this.map.put(coord, list);
            }
        }
    }

    public void set(Location loc, T object) {
        Coordinate coord = new Coordinate(loc, this.scale);
        Set<T> list = this.map.get(coord);
        if (list == null) {
            list = new HashSet<T>();
        }
        list.add(object);
        this.map.put(coord, list);
    }

    public void remove(CuboidRegion region, T object) {
        if (object == null) {
            return;
        }
        Coordinate start = new Coordinate(region.getStart(), this.scale);
        Coordinate end = new Coordinate(region.getEnd(), this.scale);
        for (int x = start.getX(); x <= end.getX(); ++x) {
            for (int z = start.getZ(); z <= end.getZ(); ++z) {
                Coordinate coord = new Coordinate(start.getWorld(), x, z);
                Set<T> list = this.map.get(coord);
                if (list == null) continue;
                list.remove(object);
                if (list.size() != 0) continue;
                this.map.remove(coord);
            }
        }
    }

    public void remove(Location loc, T object) {
        if (object == null) {
            return;
        }
        Coordinate coord = new Coordinate(loc, this.scale);
        Set<T> list = this.map.get(coord);
        if (list != null) {
            list.remove(object);
            if (list.size() == 0) {
                this.map.remove(coord);
            }
        }
    }

    public Set<T> get(Location location) {
        return this.map.getOrDefault(new Coordinate(location, this.scale), new HashSet());
    }

    public Set<T> getNearby(Location location, int radius) {
        radius /= this.scale;
        HashSet<T> set = new HashSet<T>();
        Coordinate center = new Coordinate(location, this.scale);
        for (int x = center.getX() - ++radius; x <= center.getX() + radius; ++x) {
            for (int z = center.getZ() - radius; z <= center.getZ() + radius; ++z) {
                Coordinate coord = new Coordinate(location.getWorld(), x, z);
                Set<T> tmp = this.map.get(coord);
                if (tmp == null) continue;
                set.addAll(tmp);
            }
        }
        return set;
    }

    public Set<T> getAll() {
        HashSet set = new HashSet();
        this.map.values().forEach(set::addAll);
        return set;
    }

    public void clear() {
        this.map.clear();
    }

    private static class Coordinate {
        private int x;
        private int z;
        private World world;

        public Coordinate(World world, int x, int z) {
            this.x = x;
            this.z = z;
            this.world = world;
        }

        public Coordinate(Location location, int scale) {
            this.x = location.getBlockX() / scale;
            this.z = location.getBlockZ() / scale;
            this.world = location.getWorld();
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public World getWorld() {
            return this.world;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z, this.world);
        }

        public boolean equals(Object o) {
            if (o instanceof Coordinate) {
                Coordinate other = (Coordinate)o;
                return other.x == this.x && other.z == this.z && other.world.equals((Object)this.world);
            }
            return super.equals(o);
        }
    }
}

