/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.itemutils;

import java.util.Optional;
import java.util.function.BiPredicate;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public enum ItemTrait {
    DURABILITY((a, b) -> a.getDurability() == b.getDurability()),
    AMOUNT((a, b) -> a.getAmount() == b.getAmount()),
    NAME((a, b) -> Optional.ofNullable(a.getItemMeta()).map(ItemMeta::getDisplayName).equals(Optional.ofNullable(b.getItemMeta()).map(ItemMeta::getDisplayName))),
    LORE((a, b) -> Optional.ofNullable(a.getItemMeta()).map(ItemMeta::getLore).equals(Optional.ofNullable(b.getItemMeta()).map(ItemMeta::getLore))),
    ENCHANTMENTS((a, b) -> a.getEnchantments().equals(b.getEnchantments())),
    TYPE((a, b) -> a.getType() == b.getType());

    private BiPredicate<ItemStack, ItemStack> compare;

    private ItemTrait(BiPredicate<ItemStack, ItemStack> compare) {
        this.compare = compare;
    }

    public boolean compare(ItemStack a, ItemStack b) {
        return this.compare.test(a, b);
    }
}

