/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.configmanager;

import java.util.Collection;
import java.util.Iterator;
import org.bukkit.configuration.ConfigurationSection;
import redempt.redlib.configmanager.ConfigManager;
import redempt.redlib.configmanager.ConfigObjectMapper;
import redempt.redlib.configmanager.ConfigStorage;
import redempt.redlib.configmanager.ConversionType;

public class ConfigCollection<T>
implements Collection<T>,
ConfigStorage {
    private Collection<T> wrapped;
    private Class<T> clazz;
    private ConfigObjectMapper<T> mapper;
    private ConfigurationSection section;
    private ConfigManager manager;
    private ConversionType type;

    ConfigCollection(Class<T> clazz, ConversionType type, Collection<T> wrapped) {
        this.clazz = clazz;
        this.type = type;
        this.wrapped = wrapped;
    }

    public Collection<T> getWrapped() {
        return this.wrapped;
    }

    @Override
    public void init(ConfigManager manager) {
        if (this.manager != null) {
            return;
        }
        this.mapper = new ConfigObjectMapper<T>(this.clazz, this.type, manager);
        this.manager = manager;
    }

    @Override
    public void save(ConfigurationSection section) {
        int[] count = new int[]{0};
        this.forEach(i -> {
            this.mapper.save(section, count[0] + "", i);
            count[0] = count[0] + 1;
        });
    }

    @Override
    public void load(ConfigurationSection section) {
        this.clear();
        section.getKeys(false).forEach(k -> this.add(this.mapper.load(section, (String)k)));
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.wrapped.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.wrapped.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.wrapped.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrapped.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(c);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }
}

