/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.json;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import redempt.redlib.json.JSONMap;
import redempt.redlib.json.JSONStorage;

public class JSONList
extends ArrayList<Object>
implements JSONStorage {
    private JSONStorage parent;
    protected String key = null;

    public int getInt(int key) {
        Object o = this.get(key);
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        return (Integer)o;
    }

    public boolean getBoolean(int key) {
        return (Boolean)this.get(key);
    }

    public long getLong(int key) {
        return (Long)this.get(key);
    }

    public double getDouble(int key) {
        return (Double)this.get(key);
    }

    public JSONList getList(int key) {
        return (JSONList)this.get(key);
    }

    public JSONMap getMap(int key) {
        return (JSONMap)this.get(key);
    }

    public String getString(int key) {
        return (String)this.get(key);
    }

    public <T> List<T> cast(Class<T> clazz) {
        return this.stream().map(clazz::cast).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        for (Object o : this) {
            if (o instanceof CharSequence) {
                builder.append('\"').append(o.toString().replace("\\", "\\\\").replace("\"", "\\\"")).append("\", ");
                continue;
            }
            if (o instanceof Long) {
                builder.append(o.toString()).append("L, ");
                continue;
            }
            builder.append(o).append(", ");
        }
        return builder.replace(builder.length() - 2, builder.length(), "]").toString();
    }

    @Override
    public JSONStorage getParent() {
        return this.parent;
    }

    @Override
    public void setParent(JSONStorage obj) {
        this.parent = obj;
    }

    @Override
    public void add(String key, Object value) {
        this.add(value);
    }

    @Override
    public String getTempKey() {
        return this.key;
    }

    @Override
    public void setTempKey(String value) {
        this.key = value;
    }
}

