/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlib.config.conversion;

import redempt.redlib.config.ConfigField;
import redempt.redlib.config.ConversionManager;
import redempt.redlib.config.conversion.TypeConverter;
import redempt.redlib.config.data.DataHolder;
import redempt.redlib.config.instantiation.FieldSummary;

public class StaticRootConverter {
    public static <T> TypeConverter<T> create(ConversionManager manager, Class<?> root) {
        final FieldSummary summary = FieldSummary.getFieldSummary(manager, root, true);
        return new TypeConverter<T>(){

            @Override
            public T loadFrom(DataHolder section, String path, T currentValue) {
                for (ConfigField field : summary.getFields()) {
                    Object val = summary.getConverters().get(field).loadFrom(section, field.getName(), null);
                    field.set(val);
                }
                return null;
            }

            @Override
            public void saveTo(T t, DataHolder section, String path) {
                this.saveTo(t, section, path, true);
            }

            @Override
            public void saveTo(T t, DataHolder section, String path, boolean overwrite) {
                for (ConfigField field : summary.getFields()) {
                    Object obj = field.get();
                    StaticRootConverter.saveWith(summary.getConverters().get(field), obj, section, field.getName(), overwrite);
                }
                summary.applyComments(section);
            }
        };
    }

    private static <T> void saveWith(TypeConverter<T> converter, Object obj, DataHolder section, String path, boolean overwrite) {
        converter.saveTo(obj, section, path, overwrite);
    }
}

