/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.processing;

import java.util.function.Function;

public class ArrayUtils {
    public static <T> T[] remove(T[] arr, Function<Integer, T[]> arrayConstructor, T ... toRemove) {
        int size = arr.length - toRemove.length;
        if (size < 0) {
            throw new IllegalArgumentException("Cannot remove more elements than array has");
        }
        T[] newArr = arrayConstructor.apply(size);
        int pos = 0;
        block0: for (int i = 0; i < arr.length && pos < newArr.length; ++i) {
            for (T elem : toRemove) {
                if (elem.equals(arr[i])) continue block0;
            }
            newArr[pos] = arr[i];
            ++pos;
        }
        if (pos != newArr.length) {
            throw new IllegalArgumentException("Duplicate elements or elements not present in the original array were passed");
        }
        return newArr;
    }

    public static <T> T[] concat(T[] first, T[] second, Function<Integer, T[]> arrayConstructor) {
        int size = first.length + second.length;
        T[] arr = arrayConstructor.apply(size);
        System.arraycopy(first, 0, arr, 0, first.length);
        System.arraycopy(second, 0, arr, first.length, second.length);
        return arr;
    }

    public static <T> T[] replaceRange(T[] first, T[] second, int start, int end, Function<Integer, T[]> arrayConstructor) {
        int size = first.length - (end - start) + second.length;
        T[] newArr = arrayConstructor.apply(size);
        System.arraycopy(first, 0, newArr, 0, start);
        System.arraycopy(second, 0, newArr, start, second.length);
        int to = start + second.length;
        System.arraycopy(first, end, newArr, to, newArr.length - to);
        return newArr;
    }

    public static <T> T[] remove(T[] arr, int index, Function<Integer, T[]> arrayConstructor) {
        T[] newArr = arrayConstructor.apply(arr.length - 1);
        System.arraycopy(arr, 0, newArr, 0, index);
        System.arraycopy(arr, index + 1, newArr, index, newArr.length - index);
        return newArr;
    }

    public static <T> T[] removeRange(T[] arr, int start, int end, Function<Integer, T[]> arrayConstructor) {
        int size = arr.length - (end - start);
        T[] newArr = arrayConstructor.apply(size);
        System.arraycopy(arr, 0, newArr, 0, start);
        System.arraycopy(arr, end, newArr, start, newArr.length - start);
        return newArr;
    }
}

