/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.processing.Lexer;
import redempt.redlex.token.PlaceholderToken;

public abstract class TokenType {
    private static final Map<TokenType, List<Character>> firstChars = new WeakHashMap<TokenType, List<Character>>();
    private String name;
    private int id;
    private Lexer lexer;
    private List<Character> firstCharacters;

    public TokenType(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setLexer(Lexer lexer) {
        this.setLexer(lexer, new HashSet<TokenType>());
    }

    private void setLexer(Lexer lexer, Set<TokenType> seen) {
        if (!seen.add(this)) {
            return;
        }
        this.lexer = lexer;
        if (this instanceof ParentToken) {
            for (TokenType child : ((ParentToken)((Object)this)).getChildren()) {
                child.setLexer(lexer, seen);
            }
        }
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public boolean nameMatches(String name) {
        if (name == this.name) {
            return true;
        }
        return this.name != null && this.name.equals(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Token findForward(String str, int pos, LexContext ctx) {
        int offset;
        ctx.update(pos, this);
        int start = pos;
        for (offset = 0; pos < str.length() && offset < this.maxLength() && this.characterMatches(str, pos, offset); ++pos, ++offset) {
        }
        if (!this.lengthMatches(offset)) {
            return null;
        }
        return new Token(this, str, start, pos);
    }

    public String getMessage() {
        return "Expected";
    }

    public void replacePlaceholders(Map<String, TokenType> tokens) {
        int[] counter = new int[]{0};
        this.walk(t -> {
            int n = counter[0];
            counter[0] = n + 1;
            t.id = n;
            if (!(t instanceof ParentToken)) {
                return;
            }
            ParentToken parent = (ParentToken)((Object)t);
            TokenType[] children = parent.getChildren();
            for (int i = 0; i < children.length; ++i) {
                TokenType child = children[i];
                if (!(child instanceof PlaceholderToken) || !tokens.containsKey(child.getName())) continue;
                children[i] = (TokenType)tokens.get(child.getName());
            }
            parent.setChildren(children);
        });
    }

    public void walk(Consumer<TokenType> each) {
        this.walk(each, new HashSet<TokenType>());
    }

    private void walk(Consumer<TokenType> each, Set<TokenType> visited) {
        if (!visited.add(this)) {
            return;
        }
        each.accept(this);
        if (this instanceof ParentToken) {
            ParentToken parent = (ParentToken)((Object)this);
            for (TokenType child : parent.getChildren()) {
                child.walk(each, visited);
            }
        }
    }

    public abstract boolean characterMatches(String var1, int var2, int var3);

    public abstract boolean lengthMatches(int var1);

    public abstract int minLength();

    public abstract int maxLength();

    protected abstract List<Character> calcFirstCharacters();

    public List<Character> getFirstCharacters() {
        if (this.firstCharacters == null) {
            if (!firstChars.containsKey(this)) {
                firstChars.put(this, Collections.emptyList());
                firstChars.put(this, this.calcFirstCharacters());
            }
            this.firstCharacters = firstChars.get(this);
        }
        return this.firstCharacters;
    }

    public String toString() {
        return this.name == null ? "(unnamed token " + this.id + ")" : this.name + " " + this.id;
    }
}

