/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class StringToken
extends TokenType {
    private String string;
    private boolean caseSensitive;

    public StringToken(String name, String string) {
        this(name, string, true);
    }

    public StringToken(String name, String string, boolean caseSensitive) {
        super(name);
        this.string = string;
        this.caseSensitive = caseSensitive;
        if (!caseSensitive) {
            this.string = this.string.toLowerCase(Locale.ROOT);
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    protected Token findForward(String str, int pos, LexContext ctx) {
        return this.string.regionMatches(!this.caseSensitive, 0, str, pos, this.string.length()) ? new Token(this, str, pos, pos + this.string.length()) : null;
    }

    public String getString() {
        return this.string;
    }

    @Override
    public int minLength() {
        return this.string.length();
    }

    @Override
    protected List<Character> calcFirstCharacters() {
        if (!this.caseSensitive && this.string.length() > 0) {
            ArrayList<Character> chars = new ArrayList<Character>();
            chars.add(Character.valueOf(this.string.charAt(0)));
            chars.add(Character.valueOf(Character.toUpperCase(this.string.charAt(0))));
            return chars;
        }
        return Collections.singletonList(this.string.length() == 0 ? null : Character.valueOf(this.string.charAt(0)));
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringToken)) {
            return false;
        }
        StringToken token = (StringToken)o;
        return token.string.equals(this.string);
    }
}

