/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.ArrayList;
import java.util.List;
import redempt.redlex.data.CharTree;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class StringChoiceToken
extends TokenType {
    private CharTree tree = new CharTree();
    private int min = Integer.MAX_VALUE;
    private int max = 0;

    public StringChoiceToken(String name, String[] choices) {
        super(name);
        for (String choice : choices) {
            this.tree.set(choice);
            this.min = Math.min(this.min, choice.length());
            this.max = Math.max(this.max, choice.length());
        }
    }

    @Override
    protected Token findForward(String str, int pos, LexContext ctx) {
        int len = this.tree.findForward(str, pos);
        if (len == -1) {
            return null;
        }
        return new Token(this, str, pos, len, null);
    }

    @Override
    public int minLength() {
        return this.min;
    }

    @Override
    protected List<Character> calcFirstCharacters() {
        return new ArrayList<Character>(this.tree.getFirstChars());
    }
}

