/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class CharSetToken
extends TokenType {
    private Set<Character> chars = new HashSet<Character>();
    private boolean inverted;

    public CharSetToken(String name, boolean inverted, char ... chars) {
        super(name);
        for (char c : chars) {
            this.chars.add(Character.valueOf(c));
        }
        this.inverted = inverted;
    }

    public CharSetToken(String name, char ... chars) {
        this(name, false, chars);
    }

    @Override
    public Token findForward(String input, int pos, LexContext context) {
        return pos < input.length() && this.inverted ^ this.chars.contains(Character.valueOf(input.charAt(pos))) ? new Token(this, input, pos, pos + 1) : null;
    }

    @Override
    public int minLength() {
        return 1;
    }

    @Override
    protected List<Character> calcFirstCharacters() {
        return this.inverted ? Collections.singletonList(null) : new ArrayList<Character>(this.chars);
    }

    public int hashCode() {
        return this.chars.hashCode() + (this.inverted ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CharSetToken)) {
            return false;
        }
        CharSetToken token = (CharSetToken)o;
        return token.chars.equals(this.chars) && token.inverted == this.inverted;
    }
}

