/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.data;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.function.Consumer;
import redempt.redlex.data.TokenType;
import redempt.redlex.processing.ArrayUtils;
import redempt.redlex.processing.CullStrategy;
import redempt.redlex.processing.Lexer;
import redempt.redlex.processing.ObjectToken;
import redempt.redlex.processing.TokenFilter;
import redempt.redlex.processing.TraversalOrder;

public class Token {
    public static Token[] EMPTY = new Token[0];
    private Token parent;
    private int index;
    private TokenType type;
    protected String value;
    private String sub;
    private Token[] children;
    private int start;
    private int end;

    public Token(TokenType type, String value, int start, int end, Token[] children) {
        this.type = type;
        this.value = value;
        this.start = start;
        this.end = end;
        this.setChildren(this.processChildren(children));
    }

    private Token[] processChildren(Token[] children) {
        Lexer lexer = this.type.getLexer();
        if (lexer == null || children == null) {
            return children;
        }
        ArrayList<Token> list = new ArrayList<Token>();
        block6: for (Token child : children) {
            switch (lexer.getStrategy(child)) {
                case DELETE_ALL: {
                    continue block6;
                }
                case IGNORE: {
                    list.add(child);
                    continue block6;
                }
                case DELETE_CHILDREN: {
                    child.setChildren(null);
                    list.add(child);
                    continue block6;
                }
                case LIFT_CHILDREN: {
                    Collections.addAll(list, child.getChildren());
                }
            }
        }
        return list.toArray(EMPTY);
    }

    public Token(TokenType type, String value, int start, int end) {
        this(type, value, start, end, null);
    }

    public void setChildren(Token[] children) {
        if (children == null) {
            this.children = EMPTY;
            return;
        }
        this.children = children;
        int i = 0;
        while (i < children.length) {
            Token child = children[i];
            child.index = i++;
            child.parent = this;
        }
    }

    public Token[] getChildren() {
        return this.children;
    }

    public Token getNext() {
        if (this.parent == null) {
            return null;
        }
        Token[] siblings = this.parent.getChildren();
        if (this.index > siblings.length - 2) {
            return null;
        }
        return siblings[this.index + 1];
    }

    public Token getPrevious() {
        if (this.parent == null) {
            return null;
        }
        Token[] siblings = this.parent.getChildren();
        if (this.index < 1) {
            return null;
        }
        return siblings[this.index - 1];
    }

    public Token getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public TokenType getType() {
        return this.type;
    }

    public String getValue() {
        if (this.sub == null) {
            this.sub = this.value.substring(this.start, this.end);
        }
        return this.sub;
    }

    public String getBaseString() {
        return this.value;
    }

    public int length() {
        return this.end - this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public void setValue(String value) {
        this.sub = value;
    }

    public String joinChildren(String sep) {
        StringJoiner out = new StringJoiner(sep);
        for (Token child : this.children) {
            out.add(child.getValue());
        }
        return out.toString();
    }

    public String joinLeaves(String sep) {
        if (this.children.length > 0) {
            StringJoiner out = new StringJoiner(sep);
            for (Token child : this.children) {
                out.add(child.joinLeaves(sep));
            }
            return out.toString();
        }
        return this.getValue();
    }

    public void remove() {
        if (this.parent == null) {
            throw new IllegalStateException("Token has no parent");
        }
        Token[] children = ArrayUtils.remove(this.parent.children, this.index, Token[]::new);
        this.parent.setChildren(children);
    }

    public void removeChildren(Token ... children) {
        this.setChildren(ArrayUtils.remove(this.children, Token[]::new, children));
    }

    public void removeChildren(int start, int end) {
        this.setChildren(ArrayUtils.removeRange(this.children, start, end, Token[]::new));
    }

    public Token replaceWith(Object o) {
        if (this.parent == null) {
            throw new IllegalStateException("Token has no parent");
        }
        Token[] children = this.parent.children;
        Token toReplace = o instanceof Token ? (Token)o : new ObjectToken(this, o);
        toReplace.index = this.index;
        toReplace.parent = this.parent;
        children[this.index] = toReplace;
        return toReplace;
    }

    public void replaceParent() {
        if (this.parent == null || this.parent.parent == null) {
            throw new IllegalStateException("Node does not have a grandparent");
        }
        this.parent.parent.children[this.parent.index] = this;
        this.index = this.parent.index;
        this.parent = this.parent.parent;
    }

    public void liftChildren() {
        if (this.parent == null) {
            throw new IllegalStateException("Token has no parent");
        }
        Token[] children = this.parent.children;
        Token[] newChildren = ArrayUtils.replaceRange(children, this.children, this.index, this.index + 1, Token[]::new);
        this.parent.setChildren(newChildren);
    }

    public Token firstByName(String name) {
        ArrayDeque<Token> queue = new ArrayDeque<Token>();
        queue.add(this);
        while (queue.size() > 0) {
            Token child = (Token)queue.poll();
            if (child.getType().nameMatches(name)) {
                return child;
            }
            Collections.addAll(queue, child.getChildren());
        }
        return null;
    }

    public List<Token> allByName(TraversalOrder order, String name) {
        ArrayList<Token> matching = new ArrayList<Token>();
        this.walk(order, child -> {
            if (child.getType().nameMatches(name)) {
                matching.add((Token)child);
            }
        });
        return matching;
    }

    public List<Token> allByName(String name) {
        return this.allByName(TraversalOrder.BREADTH_FIRST, name);
    }

    public Map<String, List<Token>> allByNames(String ... names) {
        return this.allByNames(TraversalOrder.BREADTH_FIRST, names);
    }

    public Map<String, List<Token>> allByNames(TraversalOrder order, String ... names) {
        HashMap<String, List<Token>> map = new HashMap<String, List<Token>>();
        for (String name : names) {
            map.put(name, new ArrayList());
        }
        this.walk(order, child -> {
            List list = (List)map.get(child.getType().getName());
            if (list != null) {
                list.add(child);
            }
        });
        return map;
    }

    public void walk(TraversalOrder order, Consumer<Token> forEachNode) {
        switch (order) {
            case SHALLOW: {
                for (Token child : this.children) {
                    forEachNode.accept(child);
                }
                break;
            }
            case BREADTH_FIRST: {
                ArrayDeque<Token> queue = new ArrayDeque<Token>();
                queue.add(this);
                while (!queue.isEmpty()) {
                    Token next = (Token)queue.poll();
                    forEachNode.accept(next);
                    Collections.addAll(queue, next.getChildren());
                }
                break;
            }
            case DEPTH_ROOT_FIRST: {
                Stack<Token> stack = new Stack<Token>();
                stack.add(this);
                while (!stack.isEmpty()) {
                    Token next = (Token)stack.pop();
                    forEachNode.accept(next);
                    Collections.addAll(stack, next.getChildren());
                }
                break;
            }
            case DEPTH_LEAF_FIRST: {
                for (Token child : this.children) {
                    child.walk(TraversalOrder.DEPTH_LEAF_FIRST, forEachNode);
                }
                forEachNode.accept(this);
            }
        }
    }

    public Object getObject() {
        return null;
    }

    public List<List<Token>> splitChildren(String name) {
        ArrayList<List<Token>> split = new ArrayList<List<Token>>();
        ArrayList<Token> current = new ArrayList<Token>();
        for (Token token : this.children) {
            if (token.getType().nameMatches(name)) {
                split.add(current);
                current = new ArrayList();
                continue;
            }
            current.add(token);
        }
        if (current.size() > 0) {
            split.add(current);
        }
        return split;
    }

    public void cull(TokenFilter ... filters) {
        ArrayList<Token> list = new ArrayList<Token>();
        block6: for (Token child : this.children) {
            CullStrategy strategy = CullStrategy.IGNORE;
            for (TokenFilter filter : filters) {
                CullStrategy action = filter.test(child);
                strategy = action.getPriority() > strategy.getPriority() ? action : strategy;
            }
            switch (strategy) {
                case IGNORE: {
                    list.add(child);
                    continue block6;
                }
                case DELETE_ALL: {
                    continue block6;
                }
                case DELETE_CHILDREN: {
                    child.setChildren(EMPTY);
                    list.add(child);
                    continue block6;
                }
                case LIFT_CHILDREN: {
                    child.cull(filters);
                    Collections.addAll(list, child.getChildren());
                }
            }
        }
        this.setChildren(list.toArray(EMPTY));
        for (Token child : this.children) {
            child.cull(filters);
        }
    }

    public void addChildren(Token ... tokens) {
        this.setChildren(ArrayUtils.concat(this.children, tokens, Token[]::new));
    }

    public String toString() {
        if (this.children.length == 0) {
            return this.type.getName() + " [" + this.getValue() + "]";
        }
        String name = this.type.getName();
        name = name == null ? "(unnamed)" : name;
        StringBuilder builder = new StringBuilder(name).append(" {");
        for (int i = 0; i < this.children.length; ++i) {
            builder.append(this.children[i].toString());
            if (i == this.children.length - 1) continue;
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }
}

