/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.processing;

import java.util.HashMap;
import java.util.Map;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;
import redempt.redlex.debug.DebugLexer;
import redempt.redlex.exception.LexException;
import redempt.redlex.processing.CullStrategy;

public class Lexer {
    private TokenType root;
    private boolean retainEmpty = false;
    private boolean retainStringLiterals = true;
    private CullStrategy unnamedRule = CullStrategy.IGNORE;
    private Map<String, CullStrategy> byName = new HashMap<String, CullStrategy>();

    public Lexer(TokenType root) {
        this.root = root;
        root.setLexer(this);
    }

    public DebugLexer debug() {
        return new DebugLexer(this.root);
    }

    public TokenType getRoot() {
        return this.root;
    }

    public CullStrategy getStrategy(Token token) {
        if (token.length() == 0 && !this.retainEmpty) {
            return CullStrategy.DELETE_ALL;
        }
        if (token.getType().getName() == null) {
            return this.unnamedRule;
        }
        if (token.getType().getName().startsWith("'") && !this.retainStringLiterals) {
            return CullStrategy.DELETE_ALL;
        }
        return this.byName.getOrDefault(token.getType().getName(), CullStrategy.IGNORE);
    }

    private int[] cursorPos(String s, int pos) {
        int newlines = 0;
        int cpos = 0;
        for (int i = 0; i < pos && i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                ++newlines;
                cpos = 0;
            }
            ++cpos;
        }
        return new int[]{newlines, cpos};
    }

    public void setRetainEmpty(boolean retainEmpty) {
        this.retainEmpty = retainEmpty;
    }

    public void setRetainStringLiterals(boolean retainStringLiterals) {
        this.retainStringLiterals = retainStringLiterals;
    }

    public void setUnnamedRule(CullStrategy unnamedRule) {
        this.unnamedRule = unnamedRule;
    }

    public void setRuleByName(CullStrategy strategy, String ... names) {
        for (String name : names) {
            this.byName.put(name, strategy);
        }
    }

    public Token tokenize(String str, boolean errorOnFail) {
        LexContext ctx = new LexContext();
        Token inst = this.root.tryTokenize(str, 0, ctx);
        if (inst == null || inst.length() != str.length()) {
            if (!errorOnFail) {
                return null;
            }
            TokenType type = ctx.getLastToken();
            type = type == null ? this.root : type;
            int[] pos = this.cursorPos(str, ctx.getLastPos());
            String[] split = str.split("\n");
            throw new LexException(type.getMessage() + " token on line " + (pos[0] + 1) + ", column " + (pos[1] + 1) + ": " + type + "\n" + (split.length == 0 ? "" : split[pos[0]]) + "\n" + this.repeat(" ", pos[1]) + "^");
        }
        return inst;
    }

    public Token tokenize(String str) {
        return this.tokenize(str, true);
    }

    private String repeat(String str, int times) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(str);
        }
        return builder.toString();
    }
}

