/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.parser;

import java.util.function.Function;
import redempt.redlex.data.Token;

public interface ParserComponent {
    public static ParserComponent mapString(String name, Function<String, Object> func) {
        return ParserComponent.coerce(ComponentType.STRING_CONTENTS, name, func);
    }

    public static ParserComponent mapChildren(String name, Function<Object[], Object> func) {
        return ParserComponent.coerce(ComponentType.CHILD_OBJECTS, name, func);
    }

    public static ParserComponent mapToken(String name, Function<Token, Object> func) {
        return ParserComponent.coerce(ComponentType.RAW_TOKEN, name, func);
    }

    public static <T> ParserComponent coerce(final ComponentType type, final String name, final Function<T, Object> func) {
        return new ParserComponent(){

            @Override
            public Object parse(Object context) {
                return func.apply(context);
            }

            @Override
            public ComponentType getType() {
                return type;
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    public Object parse(Object var1);

    public ComponentType getType();

    public String getName();

    public static enum ComponentType {
        CHILD_OBJECTS,
        STRING_CONTENTS,
        RAW_TOKEN;

    }
}

