/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.debug;

import java.util.List;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;
import redempt.redlex.debug.DebugHistory;

public class DebugToken
extends TokenType
implements ParentToken {
    private TokenType child;
    private DebugHistory history;

    public DebugToken(TokenType child, DebugHistory history) {
        super(child.getName());
        this.child = child;
        this.history = history;
    }

    public DebugHistory getHistory() {
        return this.history;
    }

    @Override
    public boolean characterMatches(String input, int pos, int offset) {
        return this.child.characterMatches(input, pos, offset);
    }

    @Override
    protected Token findForward(String str, int pos, LexContext ctx) {
        this.history.begin(this, pos);
        Token value = this.child.tryTokenize(str, pos, ctx);
        this.history.result(this, pos, value == null ? 0 : value.length(), value != null);
        return value;
    }

    @Override
    public boolean lengthMatches(int length) {
        return this.child.lengthMatches(length);
    }

    @Override
    public int minLength() {
        return this.child.minLength();
    }

    @Override
    public int maxLength() {
        return this.child.maxLength();
    }

    @Override
    protected List<Character> calcFirstCharacters() {
        return this.child.getFirstCharacters();
    }

    @Override
    public TokenType[] getChildren() {
        return new TokenType[]{this.child};
    }

    @Override
    public void setChildren(TokenType[] children) {
        if (children.length > 0) {
            this.child = children[0];
        }
    }
}

