/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.token;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import redempt.redlex.data.LexContext;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;

public class ChoiceToken
extends TokenType
implements ParentToken {
    private Map<Character, List<TokenType>> firstChars;
    private TokenType[] children;
    private int minLength = -1;
    private int maxLength = -1;

    public ChoiceToken(String name, TokenType ... children) {
        super(name);
        this.children = children;
    }

    private void initMap() {
        if (this.firstChars != null) {
            return;
        }
        this.firstChars = new HashMap<Character, List<TokenType>>();
        for (TokenType child : this.children) {
            for (Character c : child.getFirstCharacters()) {
                this.firstChars.computeIfAbsent(c, k -> new ArrayList()).add(child);
            }
        }
    }

    private void initLength() {
        if (this.minLength != -1) {
            return;
        }
        this.minLength = 0;
        for (TokenType child : this.children) {
            this.minLength = Math.min(child.minLength(), this.minLength);
            this.maxLength = Math.max(child.maxLength(), this.maxLength);
        }
    }

    @Override
    public boolean characterMatches(String input, int pos, int offset) {
        return false;
    }

    @Override
    protected Token findForward(String str, int pos, LexContext ctx) {
        char c;
        List<TokenType> types;
        Token token;
        this.initMap();
        if (pos < str.length() && (token = this.tryParse(types = this.firstChars.get(Character.valueOf(c = str.charAt(pos))), str, pos, ctx)) != null) {
            return token;
        }
        Token token2 = this.tryParse(this.firstChars.get(null), str, pos, ctx);
        return token2;
    }

    private Token tryParse(List<TokenType> children, String str, int pos, LexContext ctx) {
        if (children == null) {
            return null;
        }
        for (TokenType child : children) {
            Token inst = child.tryTokenize(str, pos, ctx);
            if (inst == null) continue;
            return new Token(this, inst.getBaseString(), inst.getStart(), inst.getEnd(), new Token[]{inst});
        }
        return null;
    }

    @Override
    public boolean lengthMatches(int length) {
        this.initLength();
        return length >= this.minLength && length <= this.maxLength;
    }

    @Override
    public int minLength() {
        this.initLength();
        return this.minLength;
    }

    @Override
    public int maxLength() {
        this.initLength();
        return this.maxLength;
    }

    @Override
    protected List<Character> calcFirstCharacters() {
        HashSet<Character> chars = new HashSet<Character>();
        for (TokenType child : this.children) {
            chars.addAll(child.getFirstCharacters());
        }
        return new ArrayList<Character>(chars);
    }

    @Override
    public TokenType[] getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(TokenType[] children) {
        this.children = children;
        this.firstChars = null;
    }
}

