/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.parser;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import redempt.redlex.data.Token;
import redempt.redlex.data.TokenType;
import redempt.redlex.parser.ParserComponent;
import redempt.redlex.processing.Lexer;

public class Parser {
    private ParserComponent[] components;
    private Lexer lexer;

    public static Parser create(Lexer lexer, ParserComponent ... components) {
        HashMap<String, ParserComponent> map = new HashMap<String, ParserComponent>();
        for (ParserComponent component : components) {
            map.put(component.getName(), component);
        }
        return new Parser(lexer, map);
    }

    private Parser(Lexer lexer, Map<String, ParserComponent> components) {
        this.lexer = lexer;
        TreeSet<TokenType> tokens = new TreeSet<TokenType>(Comparator.comparingInt(TokenType::getId));
        lexer.getRoot().walk(tokens::add);
        this.components = new ParserComponent[tokens.size()];
        int pos = 0;
        for (TokenType type : tokens) {
            this.components[pos++] = components.get(type.getName());
        }
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public Object parse(String input, boolean errorOnFail) {
        Token token = this.lexer.tokenize(input, errorOnFail);
        if (token == null) {
            return null;
        }
        return this.parse(token);
    }

    public Object parse(String input) {
        return this.parse(input, true);
    }

    private Object parse(Token token) {
        ParserComponent comp;
        try {
            comp = this.components[token.getType().getId()];
            comp.getName();
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalStateException("No parser component for token type " + token.getType().getName());
        }
        switch (comp.getType()) {
            case RAW_TOKEN: {
                return comp.parse(token);
            }
            case STRING_CONTENTS: {
                return comp.parse(token.getValue());
            }
            case CHILD_OBJECTS: {
                Token[] children = token.getChildren();
                Object[] objs = new Object[children.length];
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = this.parse(children[i]);
                }
                return comp.parse(objs);
            }
        }
        return null;
    }
}

