/*
 * Decompiled with CFR 0.152.
 */
package redempt.redlex.processing;

import java.util.Collections;
import java.util.HashSet;
import redempt.redlex.data.ParentToken;
import redempt.redlex.data.Token;
import redempt.redlex.processing.CullStrategy;

public interface TokenFilter {
    public static TokenFilter removeEmpty() {
        return t -> t.length() == 0 ? CullStrategy.DELETE_ALL : CullStrategy.IGNORE;
    }

    public static TokenFilter flatten() {
        return t -> t.getType() instanceof ParentToken ? CullStrategy.LIFT_CHILDREN : CullStrategy.IGNORE;
    }

    public static TokenFilter removeStringLiterals() {
        return t -> t.getType().getName() != null && t.getType().getName().startsWith("'") ? CullStrategy.DELETE_ALL : CullStrategy.IGNORE;
    }

    public static TokenFilter byName(CullStrategy strategy, String ... names) {
        HashSet set = new HashSet();
        Collections.addAll(set, names);
        return t -> set.contains(t.getType().getName()) ? strategy : CullStrategy.IGNORE;
    }

    public static TokenFilter removeUnnamed(CullStrategy strategy) {
        return t -> t.getType().getName() == null ? strategy : CullStrategy.IGNORE;
    }

    public CullStrategy test(Token var1);
}

